package net.argius.stew;

import java.sql.*;
import java.text.*;

import net.argius.logging.*;

/**
 * R}h@\B
 */
final class CommandProcessor {

    private static final Logger log = LoggerFactory.getLogger(CommandProcessor.class);

    private final Environment env;
    private final OutputProcessor op;

    /**
     * CommandProcessor̐B
     * @param env s
     */
    CommandProcessor(Environment env) {
        this.env = env;
        this.op = env.getOutputProcessor();
    }

    /**
     * R}hNB
     * @param parameterString
     * @return 𑱍sꍇ <code>true</code>Afꍇ <code>false</code> 
     * @throws CommandException R}hO
     */
    boolean invoke(String parameterString) throws CommandException {
        Parameter p = new Parameter(parameterString.replaceFirst("\\s", " "));
        String commandName = p.get(1);
        try {
            return invoke(commandName, new Parameter(parameterString));
        } catch (UsageException ex) {
            Object[] arguments = {commandName, ex.getMessage()};
            outputMessage("error.usage", arguments);
        } catch (DynamicLoadingException ex) {
            log.error("", ex);
            outputMessage("error.notfound", commandName);
        } catch (CommandException ex) {
            log.error("", ex);
            Throwable cause = ex.getCause();
            String message = (cause == null)
                    ? ex.getMessage()
                    : cause.getMessage();
            outputMessage("error.command", message);
        } catch (SQLException ex) {
            log.error("", ex);
            SQLException parent = ex;
            while (true) {
                SQLException sqle = parent.getNextException();
                if (sqle == null || sqle == parent) {
                    break;
                }
                log.error("------ SQLException.getNextException ------", sqle);
                parent = sqle;
            }
            outputMessage("error.sql", ex.getMessage());
        } catch (UnsupportedOperationException ex) {
            log.error("", ex);
            outputMessage("error.unsupported", ex.getMessage());
        } catch (RuntimeException ex) {
            log.error("", ex);
            outputMessage("error.runtime", ex.getMessage());
        } catch (Throwable th) {
            log.fatal("", th);
            outputMessage("error.fatal", th.getMessage());
            return false;
        }
        try {
            Connection conn = env.getCurrentConnection();
            if (conn != null) {
                boolean isClosed = conn.isClosed();
                if (isClosed) {
                    log.info("connection is already closed");
                    disconnect();
                }
            }
        } catch (SQLException ex) {
            log.warn("", ex);
        }
        return true;
    }

    /**
     * R}hNB
     * @param commandName R}h
     * @param p p[^
     * @return 𑱍sꍇ <code>true</code>Afꍇ <code>false</code>
     * @throws SQLException SQL֘AG[ꍇ
     */
    private boolean invoke(String commandName, Parameter p) throws SQLException {
        // if blank, skip to invoke
        if (StringClass.isBlank(commandName)) {
            return true;
        }
        // if exit
        if (commandName.equalsIgnoreCase("exit")) {
            disconnect();
            outputMessage("exit", Constants.PRODUCT_NAME);
            return false;
        }
        // if connect 
        if (commandName.equalsIgnoreCase("connect")
            || commandName.equalsIgnoreCase("-c")) {
            connect(p);
            return true;
        }
        // connection
        Connection conn = env.getCurrentConnection();
        if (conn == null) {
            outputMessage("error.notconnect");
        } else if (commandName.equalsIgnoreCase("disconnect")
                   || commandName.equalsIgnoreCase("-d")) {
            disconnect();
            outputMessage("disconnected");
        } else if (commandName.equalsIgnoreCase("commit")) {
            conn.commit();
            outputMessage("commited");
        } else if (commandName.equalsIgnoreCase("rollback")) {
            conn.rollback();
            outputMessage("rollbacked");
        } else {
            executeDynamicCommand(commandName, conn, p);
        }
        return true;
    }

    /**
     * ڑB
     * @param p p[^
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void connect(Parameter p) throws SQLException {
        if (log.isInfoEnabled()) {
            log.info("connect start");
        }
        disconnect();
        String id = p.get(2);
        Connector connector;
        if (!p.isEmpty(3)) {
            connector = AnonymousConnector.getConnector(id, p.get(3), p.get(4));
        } else if (id.indexOf('@') >= 0) {
            connector = AnonymousConnector.getConnector(id);
        } else {
            connector = env.getConnectorMap().getConnector(id);
        }
        if (connector != null) {
            Connection conn = connector.getConnection();
            try {
                if (connector.isReadOnly()) {
                    conn.setReadOnly(true);
                }
            } catch (RuntimeException ex) {
                log.warn("", ex);
            }
            boolean isAutoCommitAvailable;
            try {
                conn.setAutoCommit(false);
                isAutoCommitAvailable = conn.getAutoCommit();
            } catch (RuntimeException ex) {
                log.warn("", ex);
                isAutoCommitAvailable = false;
            }
            if (isAutoCommitAvailable) {
                outputMessage("warn.autocommitnotavailable");
            }
            env.setCurrentConnection(conn);
            env.setCurrentConnector(connector);
            outputMessage("connected");
        } else {
            outputMessage("error.noconnector", id);
        }
        if (log.isInfoEnabled()) {
            log.info("connect end");
        }
    }

    /**
     * RlNVؒfB
     */
    private void disconnect() {
        if (log.isDebugEnabled()) {
            log.debug("disconnect start");
        }
        try {
            env.releaseConnection();
        } catch (SQLException ex) {
            outputMessage("warn.connectionclosedabnormally");
        }
        if (log.isDebugEnabled()) {
            log.debug("disconnect end");
        }
    }

    /**
     * IR}hsB
     * @param commandName R}h
     * @param conn RlNV
     * @param p p[^
     */
    private void executeDynamicCommand(String commandName,
                                       Connection conn,
                                       Parameter p) {
        String[] splitted = commandName.split(" ");
        String capitalized = StringClass.capitalize(splitted[0]);
        String fqcn = "net.argius.stew.command." + capitalized;
        Command command = (Command)DynamicLoader.newInstance(fqcn);
        try {
            Connector connector = env.getCurrentConnector();
            if (connector.isReadOnly() && !command.isReadOnly()) {
                outputMessage("error.readonly");
                return;
            }
            command.setEnvironment(env);
            if (log.isInfoEnabled()) {
                log.info("command : " + command + " start");
            }
            if (log.isDebugEnabled()) {
                log.debug(p);
            }
            command.initialize();
            command.execute(conn, p);
        } finally {
            command.close();
        }
        if (log.isInfoEnabled()) {
            log.info("command : " + command + " end");
        }
    }

    /**
     * bZ[Wo͂B
     * @param id bZ[WID
     */
    private void outputMessage(String id) {
        outputMessage(id, new Object[0]);
    }

    /**
     * bZ[Wo͂B
     * @param id bZ[WID
     * @param argument MessageFormatɓn
     * @throws CommandException R}hO
     */
    protected void outputMessage(String id, Object argument) throws CommandException {
        outputMessage(id, new Object[]{argument});
    }

    /**
     * bZ[Wo͂B
     * @param id bZ[WID
     * @param arguments MessageFormatɓn
     * @throws CommandException R}hO
     */
    protected void outputMessage(String id, Object[] arguments) throws CommandException {
        String key = "message.command." + id;
        String message;
        if (arguments.length > 0) {
            message = MessageFormat.format(Messages.getString(key), arguments);
        } else {
            message = Messages.getString(key);
        }
        op.output(message);
    }

}