package net.argius.stew.command;

import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * sԂvR}hB
 * 
 * sԂ́A
 * <code>Statement#executeQuery(String)</code> ܂ <code>Statement#executeUpdate(String)</code>
 * ̑O̎Ԃ<code>System.currentTimemillis()</code>Ŏ擾ŌvB
 */
public final class Time extends Command {

    private static final Logger log = LoggerFactory.getLogger(Time.class);
    private static final String USAGE = getUsage("time");

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(USAGE);
        }
        int argsIndex = 2;
        String p1 = parameter.get(argsIndex);
        int times;
        if (Character.isDigit(p1.charAt(0))) {
            try {
                times = Integer.parseInt(p1);
                if (times < 1) {
                    throw new UsageException(USAGE);
                }
                ++argsIndex;
            } catch (NumberFormatException ex) {
                log.warn(ex);
                times = 1;
            }
        } else {
            times = 1;
        }
        String sql = parameter.getAll(argsIndex);
        try {
            if (times > 1) {
                tryManyTimes(conn, sql, times);
            } else {
                tryOnce(conn, sql);
            }
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

    /**
     * SQLsB
     * @param conn RlNV
     * @param sql SQL
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void tryOnce(Connection conn, String sql) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("tryOnce");
        }
        Statement stmt = conn.createStatement();
        try {
            long beginningTime;
            long endTime;
            if (isSelect(sql)) {
                beginningTime = System.currentTimeMillis();
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    endTime = System.currentTimeMillis();
                } finally {
                    rs.close();
                }
            } else {
                beginningTime = System.currentTimeMillis();
                stmt.executeUpdate(sql);
                endTime = System.currentTimeMillis();
            }
            if (log.isDebugEnabled()) {
                log.debug("beginning : " + beginningTime);
                log.debug("      end : " + endTime);
            }
            long result = endTime - beginningTime;
            Object[] arguments = {new Double(result / 1000f)};
            outputMessage("command.time.once", arguments);
        } finally {
            stmt.close();
        }
    }

    /**
     * SQL𕡐sB
     * @param conn RlNV
     * @param sql SQL
     * @param times s
     * @throws SQLException SQL֘AG[ꍇ
     */
    private void tryManyTimes(Connection conn, String sql, int times) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("tryManyTimes");
        }
        Statement stmt = conn.createStatement();
        try {
            long[] results = new long[times];
            boolean isSelect = isSelect(sql);
            for (int i = 0; i < times; i++) {
                long beginningTime;
                long endTime;
                if (log.isTraceEnabled()) {
                    log.trace("beginning : " + i);
                }
                if (isSelect) {
                    beginningTime = System.currentTimeMillis();
                    ResultSet rs = stmt.executeQuery(sql);
                    try {
                        endTime = System.currentTimeMillis();
                    } finally {
                        rs.close();
                    }
                } else {
                    beginningTime = System.currentTimeMillis();
                    stmt.executeUpdate(sql);
                    endTime = System.currentTimeMillis();
                }
                if (log.isTraceEnabled()) {
                    log.trace("      end : " + i);
                }
                results[i] = endTime - beginningTime;
            }
            long total = 0;
            long maximum = 0;
            long minimun = Long.MAX_VALUE;
            for (int i = 0; i < results.length; i++) {
                long result = results[i];
                total += result;
                maximum = Math.max(result, maximum);
                minimun = Math.min(result, minimun);
            }
            long average = total / times;
            outputMessage("command.time.total", new Double(total / 1000f));
            outputMessage("command.time.average", new Double(average / 1000f));
            outputMessage("command.time.maximum", new Double(maximum / 1000f));
            outputMessage("command.time.minimum", new Double(minimun / 1000f));
        } finally {
            stmt.close();
        }
    }

}