/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.argius.stew.io.CharSequenceFIFO;
import net.argius.stew.io.Importer;
import net.argius.stew.io.StringBasedSerializer;

public final class XmlImporter
extends Importer {
    private static final Pattern PATTERN_TAG = Pattern.compile("<(/?)([A-Za-z0-9]+)([^/>]+)?(/?) *>");
    private static final Pattern PATTERN_TAG_HEADER_ATTRIBUTE = Pattern.compile("index=\"[^0-9\"]*([0-9]+)[^0-9\"]*\"", 2);
    private static final String SLASH = "/";
    private static final String TAG_TABLE = "table";
    private static final String TAG_HEADERROW = "headerrow";
    private static final String TAG_HEADER = "header";
    private static final String TAG_ROW = "row";
    private static final String TAG_NULL = "null";
    private BufferedReader reader;
    private CharSequenceFIFO buffer;
    private char[] chars;
    private boolean hasMoreData;

    public XmlImporter(InputStream inputStream) throws IOException {
        super(inputStream);
        String string = this.getEncoding();
        this.reader = new BufferedReader(new InputStreamReader(inputStream, string));
        this.buffer = new CharSequenceFIFO();
        this.chars = new char[1024];
        this.hasMoreData = this.seekStartTag(TAG_TABLE);
    }

    private static Object parseCData(Object object) {
        String string;
        if (object instanceof String && (string = (String)object).matches("^<!\\[CDATA\\[.*\\]\\]>$")) {
            String string2 = string.substring(9, string.length() - 3);
            if (string2.indexOf("]]&gt;") >= 0) {
                string2 = string2.replaceAll("\\]\\]&gt;", "]]>");
            }
            return string2;
        }
        return object;
    }

    protected Object[] readHeader() throws IOException {
        String string;
        Object[] objectArray;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean bl = false;
        block0: while (true) {
            Matcher matcher;
            if ((matcher = PATTERN_TAG.matcher(this.buffer)).find()) {
                objectArray = matcher.group(1);
                String string2 = matcher.group(2);
                string = String.valueOf(matcher.group(3));
                String string3 = matcher.group(4);
                this.buffer.draw(matcher.end());
                if (string2.equalsIgnoreCase(TAG_HEADERROW)) {
                    if (objectArray.equals(SLASH) || string3.equals(SLASH)) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    continue;
                }
                if (string2.equalsIgnoreCase(TAG_TABLE) || string2.equalsIgnoreCase(TAG_ROW)) break;
                if (!bl || !string2.equalsIgnoreCase(TAG_HEADER)) continue;
                Matcher matcher2 = PATTERN_TAG_HEADER_ATTRIBUTE.matcher(string);
                String string4 = matcher2.find() ? matcher2.group(1) : String.valueOf(hashMap.size());
                do {
                    Matcher matcher3;
                    if (!(matcher3 = PATTERN_TAG.matcher(this.buffer)).find() || !matcher3.group(1).equals(SLASH)) continue;
                    int n = matcher3.start();
                    CharSequence charSequence = this.buffer.subSequence(0, n);
                    hashMap.put(string4, XmlImporter.parseCData(charSequence));
                    this.buffer.draw(matcher3.end());
                    continue block0;
                } while (this.readChars() > 0);
                continue;
            }
            if (this.readChars() <= 0) break;
        }
        int n = 0;
        objectArray = hashMap.keySet().iterator();
        while (objectArray.hasNext()) {
            int n2 = Integer.parseInt((String)objectArray.next());
            n = Math.max(n, n2);
        }
        objectArray = new Object[n + 1];
        for (int i = 0; i <= n; ++i) {
            string = String.valueOf(i);
            if (!hashMap.containsKey(string)) continue;
            objectArray[i] = hashMap.get(string);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            Object var2_1 = null;
            this.reader = null;
            this.buffer = null;
            this.chars = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.reader = null;
            this.buffer = null;
            this.chars = null;
            super.close();
            throw throwable;
        }
        super.close();
    }

    public Object[] nextRow() throws IOException {
        while (this.hasMoreData) {
            Matcher matcher = PATTERN_TAG.matcher(this.buffer);
            if (matcher.find()) {
                String string = matcher.group(2);
                String string2 = matcher.group(4);
                this.buffer.draw(matcher.end());
                if (string.equalsIgnoreCase(TAG_ROW)) {
                    if (string2.equals(SLASH)) {
                        return new Object[0];
                    }
                    return this.parseRow();
                }
                if (!string.equalsIgnoreCase(TAG_TABLE)) continue;
                this.hasMoreData = false;
                continue;
            }
            if (this.readChars() > 0) continue;
            this.hasMoreData = false;
            break;
        }
        return new Object[0];
    }

    private String getEncoding() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.is.read()) >= 0) {
            byteArrayOutputStream.write(n);
            if (n != 62) continue;
        }
        String string = new String(byteArrayOutputStream.toByteArray(), "ISO8859-1");
        Pattern pattern = Pattern.compile("<\\?xml.+encoding=\"([^\"]+)\"\\?>", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "utf-8";
    }

    private boolean seekStartTag(String string) throws IOException {
        do {
            String string2;
            Matcher matcher;
            if (!(matcher = PATTERN_TAG.matcher(this.buffer)).find() || (string2 = matcher.group(1)).equals(SLASH) || !string.equalsIgnoreCase(matcher.group(2))) continue;
            int n = matcher.group(4).equals(SLASH) ? matcher.start() : matcher.end();
            this.buffer.draw(n);
            return true;
        } while (this.readChars() > 0);
        return false;
    }

    private Object[] parseRow() throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block0: while (this.hasMoreData) {
            Matcher matcher = PATTERN_TAG.matcher(this.buffer);
            if (matcher.find()) {
                String string = matcher.group(1);
                String string2 = matcher.group(2);
                String string3 = matcher.group(4);
                this.buffer.draw(matcher.end());
                if (string.equals(SLASH)) {
                    if (string2.equals(TAG_ROW)) {
                        return arrayList.toArray();
                    }
                    if (!string2.equals(TAG_TABLE)) continue;
                    break;
                }
                if (string2.equalsIgnoreCase(TAG_NULL)) {
                    arrayList.add(null);
                    continue;
                }
                if (string3.equals(SLASH)) {
                    arrayList.add(XmlImporter.deserialize(string2, ""));
                    continue;
                }
                do {
                    Matcher matcher2;
                    if (!(matcher2 = PATTERN_TAG.matcher(this.buffer)).find() || !matcher2.group(1).equals(SLASH)) continue;
                    int n = matcher2.start();
                    String string4 = ((Object)this.buffer.subSequence(0, n)).toString();
                    arrayList.add(XmlImporter.deserialize(string2, string4));
                    this.buffer.draw(matcher2.end());
                    continue block0;
                } while (this.readChars() > 0);
                continue;
            }
            if (this.readChars() > 0) continue;
        }
        throw new IOException("</row> not found");
    }

    private static Object deserialize(String string, String string2) throws IOException {
        return XmlImporter.parseCData(StringBasedSerializer.deserialize(string, string2));
    }

    private int readChars() throws IOException {
        int n = this.reader.read(this.chars);
        if (n > 0) {
            this.buffer.add(this.chars, 0, n);
        }
        return n;
    }
}

