/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.ResultSetTable;
import net.argius.stew.gui.ResultSetTableModel;
import net.argius.stew.gui.TabSeparatedTextImporter;
import net.argius.stew.io.Importer;

final class ContextMenu
extends MouseAdapter {
    private static final Logger log = LoggerFactory.getLogger(ContextMenu.class);
    private final Component parent;

    ContextMenu(Component component) {
        this.parent = component;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            Object object = mouseEvent.getSource();
            if (object instanceof JTable) {
                this.showMenuForJTable((JTable)object, mouseEvent);
            } else if (object instanceof JTableHeader) {
                this.showMenuForJTableHeader((JTableHeader)object, mouseEvent);
            } else if (object instanceof JTextComponent) {
                this.showMenuForJTextComponent((JTextComponent)object, mouseEvent);
            }
        }
    }

    private void showMenuForJTable(final JTable jTable, MouseEvent mouseEvent) {
        int n;
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
        int n2 = mouseEvent.getX();
        if (jTable.columnAtPoint(new Point(n2, n = mouseEvent.getY())) <= 0) {
            return;
        }
        int n3 = jTable.getSelectedColumn();
        int n4 = jTable.getSelectedRow();
        boolean bl = resultSetTableModel.isCellEditable(n4, n3);
        boolean bl2 = resultSetTableModel.isInsertRow(n4);
        boolean bl3 = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.copy.cell"), 'C', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuCopySelectedCellValueSelected(jTable);
            }
        }, ContextMenu.getKeyStroke(67, true)));
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.paste.cell"), 'P', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuPasteValueToSelectedCellSelected(jTable);
            }
        }, ContextMenu.getKeyStroke(86, true))).setEnabled(bl);
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.null.value"), 'V', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuResetValueSelected(jTable);
            }
        }, ContextMenu.getKeyStroke(82, true))).setEnabled(bl);
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.select.all"), 'S', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuSelectAllSelected(jTable);
            }
        }, ContextMenu.getKeyStroke(65, true)));
        jPopupMenu.add(new JPopupMenu.Separator());
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.add.newrow"), 'N', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuAddNewRowSelected(jTable);
            }
        })).setEnabled(bl && !bl2);
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.add.duplicatedrow"), 'A', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuCopyInsertRowSelected(jTable);
            }
        })).setEnabled(bl && !bl2);
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.insert.paste"), 'O', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuInsertClipboardDataelected(jTable);
            }
        }, ContextMenu.getKeyStroke(73, true))).setEnabled(bl3 && !bl2);
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.fix.insert"), 'F', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuFixInsertSelected(jTable);
            }
        })).setEnabled(bl && bl2);
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.delete.row"), 'D', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuDeleteRowSelected(jTable);
            }
        })).setEnabled(bl);
        jPopupMenu.show(jTable, n2, n);
    }

    private void showMenuForJTableHeader(JTableHeader jTableHeader, MouseEvent mouseEvent) {
        final JTable jTable = jTableHeader.getTable();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        final int n3 = jTableHeader.columnAtPoint(new Point(n, n2));
        boolean bl = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("header.sort"), 'S', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuSortColumnSelected(jTable, n3);
            }
        }));
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("header.selectcolumn"), 'C', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuSelectColumnSelected(jTable, n3);
            }
        }));
        jPopupMenu.add(new JPopupMenu.Separator());
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.add.newrow"), 'N', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuAddNewRowSelected(jTable);
            }
        }));
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("table.insert.paste"), 'O', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onMenuInsertClipboardDataelected(jTable);
            }
        }, ContextMenu.getKeyStroke(73, true))).setEnabled(bl);
        jPopupMenu.show(jTableHeader, mouseEvent.getX(), mouseEvent.getY());
    }

    private void showMenuForJTextComponent(Component component, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("text.cut"), 'T', new DefaultEditorKit.CutAction(), ContextMenu.getKeyStroke(88, true)));
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("text.copy"), 'C', new DefaultEditorKit.CopyAction(), ContextMenu.getKeyStroke(67, true)));
        jPopupMenu.add(ContextMenu.createJMenuItem(ContextMenu.getMessage("text.paste"), 'P', new DefaultEditorKit.PasteAction(), ContextMenu.getKeyStroke(86, true)));
        jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
    }

    private static JMenuItem createJMenuItem(String string, char c, Action action) {
        return ContextMenu.createJMenuItem(string, c, action, null);
    }

    private static JMenuItem createJMenuItem(String string, char c, Action action, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem(string, c);
        if (action != null) {
            jMenuItem.addActionListener(action);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    private static KeyStroke getKeyStroke(int n, boolean bl) {
        return KeyStroke.getKeyStroke(n, bl ? 2 : 0);
    }

    void onMenuCopySelectedCellValueSelected(JTable jTable) {
        int n = jTable.getSelectedColumn();
        int n2 = jTable.getSelectedRow();
        Object object = jTable.getValueAt(n2, n);
        if (object != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(object.toString());
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    void onMenuPasteValueToSelectedCellSelected(JTable jTable) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable transferable = clipboard.getContents(null);
            int n = jTable.getSelectedColumn();
            int n2 = jTable.getSelectedRow();
            Object object = jTable.getValueAt(n2, n);
            Object object2 = transferable.getTransferData(DataFlavor.stringFlavor);
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
            resultSetTableModel.updateValueChanged(jTable, n2, n, object, object2);
            jTable.setValueAt(object2, n2, n);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.onError(unsupportedFlavorException);
        }
        catch (IOException iOException) {
            this.onError(iOException);
        }
        catch (SQLException sQLException) {
            this.onError(sQLException);
        }
    }

    void onMenuSelectAllSelected(JTable jTable) {
        jTable.selectAll();
    }

    void onMenuResetValueSelected(JTable jTable) {
        try {
            int n = jTable.getSelectedColumn();
            int n2 = jTable.getSelectedRow();
            Object object = jTable.getValueAt(n2, n);
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
            resultSetTableModel.updateValueChanged(jTable, n2, n, object, null);
            jTable.setValueAt(null, n2, n);
        }
        catch (SQLException sQLException) {
            this.onError(sQLException);
        }
    }

    void onMenuAddNewRowSelected(JTable jTable) {
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
        int n = resultSetTableModel.getRowCount();
        resultSetTableModel.addRowAsInsert(new Object[resultSetTableModel.getColumnCount()]);
        jTable.changeSelection(n, 1, false, false);
    }

    void onMenuCopyInsertRowSelected(JTable jTable) {
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
        int n = resultSetTableModel.getRowCount();
        int n2 = jTable.getSelectedRow();
        List list = resultSetTableModel.getDataVector().get(n2);
        resultSetTableModel.addRowAsInsert(list.toArray());
        jTable.changeSelection(n, 1, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMenuInsertClipboardDataelected(JTable jTable) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable transferable = clipboard.getContents(null);
            int n = jTable.getColumnCount();
            Object object = transferable.getTransferData(DataFlavor.stringFlavor);
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
            TabSeparatedTextImporter tabSeparatedTextImporter = new TabSeparatedTextImporter(String.valueOf(object));
            try {
                Object[] objectArray;
                ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
                int n2 = jTable.getRowCount();
                while ((objectArray = ((Importer)tabSeparatedTextImporter).nextRow()).length != 0) {
                    int n3 = Math.min(objectArray.length, n - 1);
                    Object[] objectArray2 = new Object[n3 + 1];
                    System.arraycopy(objectArray, 0, objectArray2, 1, n3);
                    resultSetTableModel.addRowAsInsert(objectArray2);
                    try {
                        resultSetTableModel.updateRowInserted(jTable, n2);
                    }
                    catch (SQLException sQLException) {
                        log.warn("", sQLException);
                        arrayList.add(sQLException);
                    }
                    ++n2;
                }
                if (!arrayList.isEmpty()) {
                    String string = arrayList.size() + " error(s) occurred";
                    DialogMessage.alert(jTable, string);
                }
            }
            finally {
                ((Importer)tabSeparatedTextImporter).close();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.onError(unsupportedFlavorException);
        }
        catch (IOException iOException) {
            this.onError(iOException);
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
        }
    }

    void onMenuFixInsertSelected(JTable jTable) {
        try {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
            resultSetTableModel.updateRowInserted(jTable);
        }
        catch (SQLException sQLException) {
            this.onError(sQLException);
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
        }
    }

    void onMenuDeleteRowSelected(JTable jTable) {
        int n;
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
        boolean bl = resultSetTableModel.isInsertRow(n = jTable.getSelectedRow());
        if (!bl) {
            try {
                resultSetTableModel.updateRowDeleted(jTable);
            }
            catch (SQLException sQLException) {
                this.onError(sQLException);
            }
        }
        resultSetTableModel.removeRow(n);
    }

    void onMenuSortColumnSelected(JTable jTable, int n) {
        if (n >= 0) {
            ResultSetTable resultSetTable = (ResultSetTable)jTable;
            resultSetTable.requestSort(n);
        }
    }

    void onMenuSelectColumnSelected(JTable jTable, int n) {
        if (n >= 0) {
            ResultSetTable resultSetTable = (ResultSetTable)jTable;
            resultSetTable.selectColumn(n);
        }
    }

    void onError(Throwable throwable) {
        log.error("", throwable);
        DialogMessage.alert(this.parent, throwable.getMessage());
    }

    private static String getMessage(String string) {
        return Messages.getString("menu.ContextMenu." + string);
    }
}

