/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.Environment;
import net.argius.stew.gui.ConnectorEditDialog;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.FlexibleDialogBase;
import net.argius.stew.gui.Messages;

final class ConnectorMapEditDialog
extends FlexibleDialogBase
implements ChangeListener {
    private final JList idList;
    private final ConnectorMap connectorMap;

    ConnectorMapEditDialog(JFrame jFrame, Environment environment) {
        super(jFrame);
        this.connectorMap = new ConnectorMap(environment.getConnectorMap());
        this.setTitle(ConnectorMapEditDialog.getMessage("title"));
        this.initializeKeyBind(this);
        this.c.anchor = 10;
        this.c.insets = new Insets(8, 12, 8, 0);
        this.idList = new JList();
        this.idList.setSelectionMode(0);
        this.initializeKeyBind(this.idList);
        this.updateList();
        JScrollPane jScrollPane = new JScrollPane(this.idList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.idList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n % 2 == 0) {
                    ConnectorMapEditDialog.this.onListDoubleClicked();
                }
            }
        });
        this.c.gridwidth = 3;
        this.c.fill = 1;
        this.addComponent(jScrollPane, false);
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 4, 2));
        JButton jButton = this.createJButton(ConnectorMapEditDialog.getMessage("button.addnew"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.onButtonNewClicked();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = this.createJButton(ConnectorMapEditDialog.getMessage("button.modify"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.onButtonModifyClicked();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = this.createJButton(ConnectorMapEditDialog.getMessage("button.remove"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.onButtonRemoveClicked();
            }
        });
        jPanel.add(jButton3);
        JButton jButton4 = this.createJButton(ConnectorMapEditDialog.getMessage("button.up"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.onButtonUpClicked();
            }
        });
        jPanel.add(jButton4);
        JButton jButton5 = this.createJButton(ConnectorMapEditDialog.getMessage("button.down"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.onButtonDownClicked();
            }
        });
        jPanel.add(jButton5);
        this.c.gridwidth = 0;
        this.c.insets = new Insets(8, 32, 8, 32);
        this.addComponent(jPanel, true);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 16, 8));
        JButton jButton6 = this.createJButton(ConnectorMapEditDialog.getMessage("button.submit"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.onButtonSubmitClicked();
            }
        });
        jPanel2.add(jButton6);
        JButton jButton7 = this.createJButton(ConnectorMapEditDialog.getMessage("button.cancel"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorMapEditDialog.this.onButtonCancelClicked();
            }
        });
        jPanel2.add(jButton7);
        this.c.gridwidth = 0;
        this.c.fill = 0;
        this.addComponent(jPanel2, false);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof Connector) {
            Connector connector = (Connector)object;
            String string = connector.getId();
            this.connectorMap.setConnector(string, connector);
            this.updateList();
        }
    }

    private void updateList() {
        this.idList.setListData(this.connectorMap.keySet().toArray());
    }

    private Object[] getElements() {
        ArrayList arrayList = new ArrayList();
        ListModel listModel = this.idList.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            arrayList.add(listModel.getElementAt(i));
        }
        return arrayList.toArray();
    }

    private void openConnectorEditDialog(Connector connector) {
        ConnectorEditDialog connectorEditDialog = new ConnectorEditDialog(this, connector);
        connectorEditDialog.addChangeListener(this);
        connectorEditDialog.setModal(true);
        connectorEditDialog.setLocationRelativeTo(this.getParent());
        connectorEditDialog.setSize(connectorEditDialog.getPreferredSize());
        connectorEditDialog.setVisible(true);
    }

    void onListDoubleClicked() {
        this.onButtonModifyClicked();
    }

    void onButtonNewClicked() {
        Connector connector = new Connector("", new Properties());
        this.openConnectorEditDialog(connector);
    }

    void onButtonModifyClicked() {
        Object e = this.idList.getSelectedValue();
        if (e instanceof String) {
            String string = (String)e;
            Connector connector = this.connectorMap.getConnector(string);
            this.openConnectorEditDialog(connector);
        }
    }

    void onButtonRemoveClicked() {
        Object e = this.idList.getSelectedValue();
        this.connectorMap.remove(e);
        this.updateList();
    }

    void onButtonUpClicked() {
        int n = this.idList.getSelectedIndex();
        if (n > 0) {
            Object[] objectArray = this.getElements();
            Object object = objectArray[n];
            objectArray[n] = objectArray[n - 1];
            objectArray[n - 1] = object;
            this.idList.setListData(objectArray);
            this.idList.setSelectedIndex(n - 1);
        }
    }

    void onButtonDownClicked() {
        int n;
        int n2 = this.idList.getSelectedIndex();
        if (n2 < (n = this.idList.getModel().getSize()) - 1) {
            Object[] objectArray = this.getElements();
            Object object = objectArray[n2];
            objectArray[n2] = objectArray[n2 + 1];
            objectArray[n2 + 1] = object;
            this.idList.setListData(objectArray);
            this.idList.setSelectedIndex(n2 + 1);
        }
    }

    void onButtonSubmitClicked() {
        int n = DialogMessage.confirmYesNo(this, ConnectorMapEditDialog.getMessage("confirm.save"));
        if (n != 0) {
            return;
        }
        ConnectorMap connectorMap = new ConnectorMap();
        Object[] objectArray = this.getElements();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            connectorMap.setConnector(string, this.connectorMap.getConnector(string));
        }
        try {
            ConnectorConfiguration.save(connectorMap);
            this.connectorMap.clear();
            this.connectorMap.putAll(connectorMap);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage());
        }
        this.dispose();
    }

    void onButtonCancelClicked() {
        this.dispose();
    }

    private static String getMessage(String string) {
        return Messages.getString("dialog.ConnectorMapEditDialog." + string);
    }
}

