/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;
import net.argius.stew.command.Load;
import net.argius.stew.io.Importer;

public final class Import
extends Load {
    private static final Logger log = LoggerFactory.getLogger(Import.class);
    private static final String USAGE = Import.getUsage("import");

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(USAGE);
        }
        int n = 2;
        String string = parameter.get(n++);
        String string2 = parameter.get(n++);
        String string3 = parameter.get(n++);
        boolean bl = string3.equalsIgnoreCase("header");
        if (log.isDebugEnabled()) {
            log.debug("file : " + string);
            log.debug("table : " + string2);
            log.debug("hasHeader : " + bl);
        }
        try {
            this.loadRecord(connection, new File(string), string2, bl);
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    protected void insertRecords(PreparedStatement preparedStatement, Importer importer) throws IOException, SQLException {
        Object[] objectArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((objectArray = importer.nextRow()).length != 0) {
            ++n;
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    preparedStatement.setObject(i + 1, objectArray[i]);
                }
                preparedStatement.addBatch();
            }
            catch (SQLException sQLException) {
                String string = "error occurred at " + n;
                if (log.isTraceEnabled()) {
                    log.trace(string, sQLException);
                } else if (log.isDebugEnabled()) {
                    log.debug(string + " : " + sQLException);
                }
                ++n3;
            }
        }
        objectArray = preparedStatement.executeBatch();
        n2 = objectArray.length;
        if (log.isDebugEnabled()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(Integer.toString((int)objectArray[i]));
            }
            log.debug("updateCounts = " + arrayList);
            log.debug("record   = " + n);
            log.debug("inserted = " + n2);
            log.debug("error    = " + n3);
        }
        Object[] objectArray2 = new Object[]{new Integer(n2), new Integer(n)};
        this.outputMessage(".loaded", objectArray2);
    }
}

