/*
 * Decompiled with CFR 0.152.
 */
package net.argius.logging;

import java.lang.reflect.Constructor;
import net.argius.logging.Logger;
import net.argius.logging.NullLogger;
import net.argius.logging.StandardErrorOutputLogger;

public class LoggerFactory {
    private static final String PROPERTYKEY_ENABLE = "net.argius.logging";
    private static final String PROPERTYKEY_CLASS = "net.argius.logging.class";
    private static final String PROPERTYKEY_LEVEL = "net.argius.logging.level";

    private LoggerFactory() {
    }

    public static Logger getLogger() {
        return LoggerFactory.createLogger("");
    }

    public static Logger getLogger(String string) {
        return LoggerFactory.createLogger(string);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.createLogger(clazz.getName());
    }

    private static Logger createLogger(String string) {
        Logger logger;
        if (Boolean.getBoolean(PROPERTYKEY_ENABLE)) {
            String string2 = System.getProperty(PROPERTYKEY_CLASS);
            try {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                logger = (Logger)constructor.newInstance(string);
            }
            catch (Throwable throwable) {
                logger = new StandardErrorOutputLogger(string);
                logger.warn("", throwable);
            }
        } else {
            logger = new NullLogger();
        }
        logger.setLevel(System.getProperty(PROPERTYKEY_LEVEL));
        return logger;
    }
}

