package net.argius.stew.text;

/**
 * ̌ҏWB
 * VCX^X͐łȂB
 */
public final class Trimmer {

    /** E */
    public static final Trimmer LEFT = new Trimmer(1);
    /** EE */
    public static final Trimmer RIGHT = new Trimmer(2);

    private static final String EMPTY = "";
    private static final char SPACE = ' ';

    private final int code;

    /**
     * Trimmer̐B
     * @param code 萔
     */
    private Trimmer(int code) {
        this.code = code;
    }

    /**
     * ҏWsB
     * 񂪎w肵蒷ꍇ͌؂肷B
     * 񂪎w肵Zꍇ̓Xy[XŌ߂B
     * ͍񂹂ƂȂB
     * @param s 
     * @param length ҏW̌ioCgj
     * @return ҏWꂽ
     */
    public static String trim(String s, int length) {
        return trim(s, length, LEFT);
    }

    /**
     * ҏWsB
     * 񂪎w肵蒷ꍇ͌؂肷B
     * 񂪎w肵Zꍇ̓Xy[XŌ߂B
     * @param s 
     * @param length ҏW̌ioCgj
     * @param direction 
     * @return ҏWꂽ
     */
    public static String trim(String s, int length, Trimmer direction) {
        int blength = s.getBytes().length;
        if (blength < length) {
            return pad(s, length, SPACE, direction);
        } else if (blength > length) {
            return cut(s, length, direction);
        } else {
            return s;
        }
    }

    /**
     * ߏsB
     * ߂镶͔pXy[XgpB
     * ͍񂹂ƂȂB
     * 񂪎w肵蒷ꍇ͉ȂB
     * @param s 
     * @param length ҏW̌ioCgj
     * @return ҏWꂽ
     */
    public static String pad(String s, int length) {
        return pad(s, length, SPACE);
    }

    /**
     * ߏsB
     * ͍񂹂ƂȂB
     * 񂪎w肵蒷ꍇ͉ȂB
     * @param s 
     * @param length ҏW̌ioCgj
     * @param padding ߂Ɏgp镶
     * @return ҏWꂽ
     */
    public static String pad(String s, int length, char padding) {
        return pad(s, length, padding, LEFT);
    }

    /**
     * ߏsB
     * 񂪎w肵蒷ꍇ͉ȂB
     * @param s 
     * @param length ҏW̌ioCgj
     * @param padding ߂Ɏgp镶
     * @param direction 
     * @return ҏWꂽ
     */
    public static String pad(String s,
                             int length,
                             char padding,
                             Trimmer direction) {
        if (length <= s.getBytes().length) {
            return s;
        }
        StringBuffer buffer = new StringBuffer(s);
        if (direction == LEFT) {
            while (buffer.toString().getBytes().length < length) {
                buffer.append(padding);
            }
        } else if (direction == RIGHT) {
            while (buffer.toString().getBytes().length < length) {
                buffer.insert(0, padding);
            }
        }
        return buffer.toString();
    }

    /**
     * ؂菈sB
     * ͍񂹂ƂȂB
     * 񂪎w肵Zꍇ͉ȂB
     * @param s 
     * @param length ҏW̌ioCgj
     * @return ҏWꂽ
     */
    public static String cut(String s, int length) {
        return cut(s, length, LEFT);
    }

    /**
     * ؂菈sB
     * Ƀ[ȉw肳ꂽꍇA󕶎ԂB
     * 񂪎w肵Zꍇ͉ȂB
     * @param s 
     * @param length ҏW̌ioCgj
     * @param direction 
     * @return ҏWꂽ
     */
    public static String cut(String s, int length, Trimmer direction) {
        if (length <= 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer(s);
        while (length < sb.toString().getBytes().length) {
            if (direction == LEFT) {
                sb.deleteCharAt(sb.length() - 1);
            } else if (direction == RIGHT) {
                sb.deleteCharAt(0);
            }
        }
        return sb.toString();
    }

    /* (overridden)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        int result = 17;
        result = 37 * result + code;
        return result;
    }

}