package net.argius.stew.io;

import java.io.*;
import java.util.*;

import net.argius.stew.*;

/**
 * CC|[gB
 * 
 * ͓̏ȂB
 */
public final class SmartImporter extends Importer {

    private final InputStreamBuffer buffer;
    private final String separator;

    private final int separatorLength;

    /**
     * SmartImporter̐B
     * @param is ̓Xg[
     * @param separator 
     */
    public SmartImporter(InputStream is, String separator) {
        super(is);
        this.buffer = new InputStreamBuffer(is);
        this.separator = separator;
        this.separatorLength = separator.length();
    }

    /* (overridden)
     * @see net.argius.stew.io.Importer#close()
     */
    public void close() throws IOException {
        try {
            buffer.close();
        } finally {
            super.close();
        }
    }

    /* (overridden)
     * @see net.argius.stew.io.Importer#nextRow()
     */
    public Object[] nextRow() throws IOException {
        List row = new ArrayList();
        while (true) {
            if (!buffer.fill(1)) {
                break;
            }
            int start;
            int offset;
            int quoteEnd;
            boolean isQuote = false;
            char initial = buffer.charAt(0);
            if (initial == '"') {
                // quote
                if (buffer.fill(2)) {
                    int fromIndex = 1;
                    while (true) {
                        int i = buffer.indexOf(initial, fromIndex, true);
                        if (i < 0) {
                            start = 0;
                            quoteEnd = buffer.length();
                            break;
                        }
                        if (buffer.fill(i + 1)
                            && buffer.charAt(i + 1) == initial) {
                            fromIndex = i + 2;
                        } else {
                            start = 1;
                            quoteEnd = i;
                            isQuote = true;
                            break;
                        }
                    }
                } else {
                    start = 0;
                    quoteEnd = buffer.length();
                }
                offset = quoteEnd + 1;
            } else {
                // not quote
                start = 0;
                quoteEnd = -1;
                offset = 0;
            }
            int index;
            int drawLength = 0;
            boolean isRowEnd = false;
            while (true) {
                int length = buffer.length();
                int indexLS = buffer.indexOf('\r', offset, false);
                boolean hasCR = indexLS >= 0;
                if (!hasCR) {
                    indexLS = buffer.indexOf('\n', offset, false);
                }
                int indexCS = buffer.indexOf(separator, offset, false);
                if (indexLS < 0 && indexCS < 0) {
                    // not found
                    if (buffer.readChars() <= 0) {
                        index = length;
                        drawLength = length;
                        isRowEnd = true;
                        break;
                    }
                    offset = length;
                    continue;
                } else if (indexLS >= 0 && (indexLS < indexCS || indexCS < 0)) {
                    // end of line
                    int lssize = 1;
                    if (hasCR && length > indexLS) {
                        if (buffer.fill(indexLS + 2)
                            && buffer.charAt(indexLS + 1) == '\n') {
                            lssize += 1;
                        }
                    }
                    index = indexLS;
                    drawLength = indexLS + lssize;
                    isRowEnd = true;
                    break;
                } else if (indexCS >= 0) {
                    // separator
                    index = indexCS;
                    drawLength = indexCS + separatorLength;
                    break;
                } else {
                    throw new UnexpectedError();
                }
            }
            int end = (isQuote ? quoteEnd : index);
            CharSequence value = buffer.draw(drawLength)
                                       .subSequence(start, end);
            addColumn(row, value);
            if (isRowEnd) {
                break;
            }
        }
        return row.toArray();
    }

    /**
     * vf̒ǉB
     * @param row s
     * @param cs V[PX
     */
    private static void addColumn(List row, CharSequence cs) {
        StringBuffer buffer = new StringBuffer(cs.length());
        String[] splitted = cs.toString().split("\"\"");
        for (int i = 0; i < splitted.length; i++) {
            if (i != 0) {
                buffer.append('"');
            }
            buffer.append(splitted[i]);
        }
        row.add(buffer.toString());
    }

}