package net.argius.stew.io;

import java.io.*;

import net.argius.stew.*;

/**
 * ȈՃGNX|[gB
 */
public final class SimpleExporter extends Exporter {

    private static final String PROP_FORMAT = SimpleExporter.class.getName()
                                              + ".format";

    private final String separator;
    private final CsvFormatter formatter;

    private PrintWriter out;

    /**
     * SimpleExporter̐B
     * @param os o̓Xg[
     * @param separator 
     */
    public SimpleExporter(OutputStream os, String separator) {
        super(os);
        this.out = new PrintWriter(os);
        this.separator = separator;
        this.formatter = getCsvFormatter();
    }

    /**
     * CsvFormatter̎擾
     * @return CsvFormatter
     */
    private static CsvFormatter getCsvFormatter() {
        String formatMode = LocalSystem.getProperty(PROP_FORMAT);
        if (formatMode.equalsIgnoreCase("RAW")) {
            return CsvFormatter.RAW;
        } else if (formatMode.equalsIgnoreCase("STRING")) {
            return CsvFormatter.STRING;
        } else if (formatMode.equalsIgnoreCase("ESCAPE")) {
            return CsvFormatter.ESCAPE;
        } else {
            return CsvFormatter.AUTO;
        }
    }

    /* (overridden)
     * @see net.argius.stew.io.Exporter#addRow(java.lang.Object[])
     */
    public void addRow(Object[] row) {
        for (int i = 0; i < row.length; i++) {
            Object o = row[i];
            if (i > 0) {
                out.print(separator);
            }
            String value;
            if (o instanceof String) {
                value = (String)o;
            } else if (row[i] != null) {
                value = o.toString();
            } else {
                value = StringClass.EMPTY;
            }
            out.print(formatter.format(value));
        }
        out.println();
        out.flush();
    }

    /* (overridden)
     * @see net.argius.stew.io.Exporter#close()
     */
    public void close() throws IOException {
        try {
            if (out != null) {
                out.flush();
                out.close();
            }
        } finally {
            out = null;
            super.close();
        }
    }

}