package net.argius.stew.io;

/**
 * CSV`̏o̓tH[}bgB
 *
 * ̃NX͐VȃCX^X𐶐łȂB
 */
public final class CsvFormatter {

    private static final int iRAW = 0x0201;
    private static final int iSTRING = 0x0401;
    private static final int iESCAPE = 0x0801;
    private static final int iAUTO = 0x1001;

    /**
     * lҏWɏoo͌`B 
     */
    public static final CsvFormatter RAW = new CsvFormatter(iRAW);

    /**
     * Ƃďoo͌`B
     * <code>=" "</code>ň͂ށB
     */
    public static final CsvFormatter STRING = new CsvFormatter(iSTRING);

    /**
     * LGXP[vo͌`B 
     * <code>" "</code>ň͂ށB
     * ؂蕶slƂďo͂ꍇɎgpB
     */
    public static final CsvFormatter ESCAPE = new CsvFormatter(iESCAPE);

    /**
     * ̎ނoo͌`B
     * 
     * A𒲂ׂĂҏW邽߁ARXgB
     * ̓Iȓ́Aȉ̂ƂB
     * <pre>
     *     s܂܂Ăꍇ - ESCAPE
     *     ؂蕶܂܂Ăꍇ - ESCAPE
     *     [Ŏn܂鐔liQȏj̏ꍇ - STRING
     *     ŉʂ̌[̐l̏ꍇ - STRING
     *     int̍ől𒴂鐔l̏ꍇ - STRING
     * </pre>
     */
    public static final CsvFormatter AUTO = new CsvFormatter(iAUTO);

    private final int form;

    /**
     * CsvFormatter̐B
     * @param form ID
     */
    private CsvFormatter(int form) {
        this.form = form;
    }

    /**
     * tH[}bgB
     * @param value 
     * @return ҏWꂽ
     */
    public String format(String value) {
        switch (form) {
            case iRAW:
                return value;
            case iSTRING:
                return editAsStringValue(value);
            case iESCAPE:
                return editAsEscapeValue(value);
            case iAUTO:
                return editAuto(value);
            default:
                return value;
        }
    }

    /**
     * Iɏo͌`IătH[}bgB
     * @param value l
     * @return ҏWꂽl
     */
    private String editAuto(String value) {
        // null܂͋󕶎͏Ȃ
        if (value == null || value.length() == 0) {
            return value;
        }
        // _uNH[e[Vi"j܂܂Ăꍇ - STRING
        if (value.indexOf('"') >= 0) {
            return editAsEscapeValue(value.replaceAll("\"", "\"\""));
        }
        // s܂܂Ăꍇ - STRING
        if (value.indexOf('\r') >= 0 || value.indexOf('\n') >= 0) {
            return editAsEscapeValue(value);
        }
        String trimmed = value.trim();
        if (trimmed.length() > 0) {
            // ܂܂Ăꍇ - STRING
            if (trimmed.indexOf(',') >= 0) {
                return editAsEscapeValue(value);
            }
            char initial = trimmed.charAt(0);
            // [Ŏn܂鐔liQȏj̏ꍇ - QUOTE
            if (initial == '0' && trimmed.length() >= 2) {
                try {
                    Double.parseDouble(value);
                    return editAsStringValue(value);
                } catch (NumberFormatException ex) {
                    // ignore
                }
            }
            // ŉʂ̌[̐l̏ꍇ - QUOTE
            if (trimmed.indexOf('.') >= 0
                && trimmed.charAt(trimmed.length() - 1) == '0') {
                try {
                    Double.parseDouble(value);
                    return editAsStringValue(value);
                } catch (NumberFormatException ex) {
                    // ignore
                }
            }
            // int̍ől𒴂鐔l̏ꍇ - QUOTE
            if ('0' <= initial && initial <= '9') {
                try {
                    if (Long.parseLong(trimmed) > Integer.MAX_VALUE) {
                        return editAsStringValue(value);
                    }
                } catch (NumberFormatException ex) {
                    // ignore
                }
            }
        }
        return value;
    }

    /**
     * pꂽ`<code>(=" ")</code>ɕҏWB 
     * @param value l
     * @return ҏWꂽl
     */
    private String editAsStringValue(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("=\"");
        sb.append(escapeQuote(value));
        sb.append('"');
        return sb.toString();
    }

    /**
     * J}sGXP[v`<code>(" ")</code>ɕҏWB 
     * @param value l
     * @return ҏWꂽl
     */
    private String editAsEscapeValue(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append('"');
        sb.append(escapeQuote(value));
        sb.append('"');
        return sb.toString();
    }

    /**
     * pGXP[vB
     * @param string 
     * @return ҏWꂽ
     */
    private static String escapeQuote(String string) {
        return string.replaceAll("\"", "\"\"");
    }

}