package net.argius.logging;

import java.io.*;
import java.text.*;
import java.util.*;
import java.util.logging.*;

/**
 * LoggingFormatter̊{B
 */
public class BasicFormatter extends Formatter {

    private static final String FORMAT_DATETIME = "yyyy/MM/dd HH:mm:ss.SSS";

    /* (overridden)
     * @see java.util.logging.Formatter#format(java.util.logging.LogRecord)
     */
    public String format(LogRecord record) {
        Writer buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        Date now = new Date(record.getMillis());
        out.print(new SimpleDateFormat(FORMAT_DATETIME).format(now));
        out.print(' ');
        out.print(Thread.currentThread().getName());
        out.print(' ');
        out.println(record.getMessage());
        return buffer.toString();
    }

}
