package net.argius.stew.gui;

import java.awt.*;

import javax.swing.*;
import javax.swing.table.*;

import net.argius.stew.*;
import net.argius.stew.text.*;

/**
 * ResultSetTable̍sԍ\TableCellRendererB
 */
class ResultSetTableRowNumberCellRenderer extends DefaultTableCellRenderer {

    /** Singleton */
    static final ResultSetTableRowNumberCellRenderer INSTANCE = new ResultSetTableRowNumberCellRenderer();

    /**
     * ResultSetTableRowNumberCellRenderer̐B
     */
    private ResultSetTableRowNumberCellRenderer() {
        // empty
    }

    /* (overridden)
     * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column) {
        String s;
        if (value == null || StringClass.isBlank(value.toString())) {
            s = String.valueOf(row + 1);
        } else {
            s = value.toString();
        }
        JLabel label = new JLabel(Trimmer.pad(s, 6, ' ', Trimmer.RIGHT));
        label.setFont(table.getFont());
        label.setOpaque(true);
        return label;
    }

}