package net.argius.stew.gui;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;

/**
 * ResultSetTablewb_TableCellRendererB
 */
class ResultSetTableHeaderCellRenderer extends DefaultTableCellRenderer {

    private TableCellRenderer cellRenderer;
    private boolean isShowUpdatableSign;
    private boolean isShowNumber;

    /**
     * ResultSetTableHeaderCellRenderer̐B
     */
    ResultSetTableHeaderCellRenderer() {
        // empty
    }

    /**
     * ResultSetTableHeaderCellRenderer̐B
     * @param cellRenderer
     */
    ResultSetTableHeaderCellRenderer(TableCellRenderer cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    /**
     * XV\TC\Ԃ̎擾B
     * @return XV\TC\
     */
    public boolean isShowUpdatableSign() {
        return isShowUpdatableSign;
    }

    /**
     * XV\TC\Ԃ̐ݒB
     * @param isShowUpdatableSign XV\TC\
     */
    public void setShowUpdatableSign(boolean isShowUpdatableSign) {
        this.isShowUpdatableSign = isShowUpdatableSign;
    }

    /**
     * ԍ\Ԃ̎擾B
     * @return ԍ\
     */
    boolean isShowNumber() {
        return isShowNumber;
    }

    /**
     * ԍ\Ԃ̐ݒB
     * @param isShowNumber ԍ\
     */
    void setShowNumber(boolean isShowNumber) {
        this.isShowNumber = isShowNumber;
    }

    /* (overridden)
     * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column) {
        if (row == -1 && column == 0) {
            JLabel label = new JLabel(new UpdatableSignIcon(isShowUpdatableSign));
            label.setBorder(new LineBorder(Color.LIGHT_GRAY));
            return label;
        }
        Object displayValue;
        if (isShowNumber && column > 0) {
            displayValue = String.valueOf(column) + ' ' + value;
        } else {
            displayValue = value;
        }
        return cellRenderer.getTableCellRendererComponent(table,
                                                          displayValue,
                                                          isSelected,
                                                          hasFocus,
                                                          row,
                                                          column);
    }

    /**
     * XVۃTC̃ACRB
     */
    private static final class UpdatableSignIcon extends ImageIcon {

        private static final long serialVersionUID = 2058287919003413222L;

        /**
         * ResultSetTableHeaderCellRenderer.UpdatableSignIcon̐B
         * @param updatable
         */
        UpdatableSignIcon(boolean updatable) {
            super(UpdatableSignIcon.class.getResource("icon.updatable."
                                                      + updatable
                                                      + ".gif"));
        }

    }

}