package net.argius.stew.gui;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.text.*;

import net.argius.logging.*;
import net.argius.stew.io.*;

/**
 * ReLXgj[B
 */
final class ContextMenu extends MouseAdapter {

    private static final Logger log = LoggerFactory.getLogger(ContextMenu.class);

    private final Component parent;

    /**
     * ContextMenu̐B
     * @param parent
     */
    ContextMenu(Component parent) {
        this.parent = parent;
    }

    /* (overridden)
     * @see java.awt.event.MouseAdapter#mouseClicked(java.awt.event.MouseEvent)
     */
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            Object source = e.getSource();
            if (source instanceof JTable) {
                showMenuForJTable((JTable)source, e);
            } else if (source instanceof JTableHeader) {
                showMenuForJTableHeader((JTableHeader)source, e);
            } else if (source instanceof JTextComponent) {
                showMenuForJTextComponent((JTextComponent)source, e);
            }
        }
    }

    /**
     * JTablep̃ReLXgj[\B
     * @param table KpΏۂ̃R|[lg
     * @param e }EXCxg
     */
    private void showMenuForJTable(final JTable table, MouseEvent e) {
        final ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        final int x = e.getX();
        final int y = e.getY();
        if (table.columnAtPoint(new Point(x, y)) <= 0) {
            return;
        }
        final int selectedColumn = table.getSelectedColumn();
        final int selectedRow = table.getSelectedRow();
        final boolean isCellEditable = model.isCellEditable(selectedRow,
                                                            selectedColumn);
        final boolean isSelectedInsertRow = model.isInsertRow(selectedRow);
        final boolean isClipboardEnabled = Toolkit.getDefaultToolkit()
                                                  .getSystemClipboard()
                                                  .getContents(null)
                                                  .isDataFlavorSupported(DataFlavor.stringFlavor);
        JPopupMenu popup = new JPopupMenu();
        popup.add(createJMenuItem(getMessage("table.copy.cell"),
                                  'C',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuCopySelectedCellValueSelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_C, true)));
        popup.add(createJMenuItem(getMessage("table.paste.cell"),
                                  'P',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuPasteValueToSelectedCellSelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_V, true)))
             .setEnabled(isCellEditable);
        popup.add(createJMenuItem(getMessage("table.null.value"),
                                  'V',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuResetValueSelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_R, true)))
             .setEnabled(isCellEditable);
        popup.add(createJMenuItem(getMessage("table.select.all"),
                                  'S',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuSelectAllSelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_A, true)));
        popup.add(new JPopupMenu.Separator());
        popup.add(createJMenuItem(getMessage("table.add.newrow"),
                                  'N',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuAddNewRowSelected(table);
                                      }

                                  }))
             .setEnabled(isCellEditable && !isSelectedInsertRow);
        popup.add(createJMenuItem(getMessage("table.add.duplicatedrow"),
                                  'A',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuCopyInsertRowSelected(table);
                                      }

                                  }))
             .setEnabled(isCellEditable && !isSelectedInsertRow);
        popup.add(createJMenuItem(getMessage("table.insert.paste"),
                                  'O',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuInsertClipboardDataelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_I, true)))
             .setEnabled(isClipboardEnabled && !isSelectedInsertRow);
        popup.add(createJMenuItem(getMessage("table.fix.insert"),
                                  'F',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuFixInsertSelected(table);
                                      }

                                  }))
             .setEnabled(isCellEditable && isSelectedInsertRow);
        popup.add(createJMenuItem(getMessage("table.delete.row"),
                                  'D',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuDeleteRowSelected(table);
                                      }

                                  }))
             .setEnabled(isCellEditable);
        popup.show(table, x, y);
    }

    /**
     * JTableHeaderp̃ReLXgj[\B
     * @param component KpΏۂ̃R|[lg
     * @param e }EXCxg
     */
    private void showMenuForJTableHeader(JTableHeader component, MouseEvent e) {
        final JTable table = component.getTable();
        final int x = e.getX();
        final int y = e.getY();
        final int columnIndex = component.columnAtPoint(new Point(x, y));
        final boolean isClipboardEnabled = Toolkit.getDefaultToolkit()
                                                  .getSystemClipboard()
                                                  .getContents(null)
                                                  .isDataFlavorSupported(DataFlavor.stringFlavor);
        JPopupMenu popup = new JPopupMenu();
        popup.add(createJMenuItem(getMessage("header.sort"),
                                  'S',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuSortColumnSelected(table,
                                                                   columnIndex);
                                      }

                                  }));
        popup.add(createJMenuItem(getMessage("header.selectcolumn"),
                                  'C',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuSelectColumnSelected(table,
                                                                     columnIndex);
                                      }

                                  }));
        popup.add(new JPopupMenu.Separator());
        popup.add(createJMenuItem(getMessage("table.add.newrow"),
                                  'N',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuAddNewRowSelected(table);
                                      }

                                  }));
        popup.add(createJMenuItem(getMessage("table.insert.paste"),
                                  'O',
                                  new AbstractAction() {

                                      public void actionPerformed(ActionEvent e) {
                                          onMenuInsertClipboardDataelected(table);
                                      }

                                  },
                                  getKeyStroke(KeyEvent.VK_I, true)))
             .setEnabled(isClipboardEnabled);
        popup.show(component, e.getX(), e.getY());
    }

    /**
     * JTextComponentp̃ReLXgj[\B
     * @param component KpΏۂ̃R|[lg
     * @param e }EXCxg
     */
    private void showMenuForJTextComponent(Component component, MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        popup.add(createJMenuItem(getMessage("text.cut"),
                                  'T',
                                  new DefaultEditorKit.CutAction(),
                                  getKeyStroke(KeyEvent.VK_X, true)));
        popup.add(createJMenuItem(getMessage("text.copy"),
                                  'C',
                                  new DefaultEditorKit.CopyAction(),
                                  getKeyStroke(KeyEvent.VK_C, true)));
        popup.add(createJMenuItem(getMessage("text.paste"),
                                  'P',
                                  new DefaultEditorKit.PasteAction(),
                                  getKeyStroke(KeyEvent.VK_V, true)));
        popup.show(component, e.getX(), e.getY());
    }

    /**
     * JMenuItem̐B
     * @param caption \
     * @param mnemonic 蓖ĕ
     * @param action ANV
     * @return JMenuItem
     */
    private static JMenuItem createJMenuItem(String caption,
                                             char mnemonic,
                                             Action action) {
        return createJMenuItem(caption, mnemonic, action, null);
    }

    /**
     * JMenuItem̐B
     * @param caption \
     * @param mnemonic 蓖ĕ
     * @param action ANV
     * @param shortcut V[gJbgL[
     * @return JMenuItem
     */
    private static JMenuItem createJMenuItem(String caption,
                                             char mnemonic,
                                             Action action,
                                             KeyStroke shortcut) {
        JMenuItem item = new JMenuItem(caption, mnemonic);
        if (action != null) {
            item.addActionListener(action);
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    /**
     * KeyStroke̎擾B
     * @param key L[
     * @param withControlKey Rg[L[gpꍇ <code>true</code>
     * @return KeyStroke
     */
    private static KeyStroke getKeyStroke(int key, boolean withControlKey) {
        return KeyStroke.getKeyStroke(key, (withControlKey
                ? InputEvent.CTRL_MASK
                : 0));
    }

    /**
     * j["ZRs["IꂽƂ̏B
     * @param table e[u
     */
    void onMenuCopySelectedCellValueSelected(JTable table) {
        int selectedColumn = table.getSelectedColumn();
        int selectedRow = table.getSelectedRow();
        Object o = table.getValueAt(selectedRow, selectedColumn);
        if (o != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit()
                                         .getSystemClipboard();
            StringSelection ss = new StringSelection(o.toString());
            clipboard.setContents(ss, ss);
        }
    }

    /**
     * j["Z\t"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuPasteValueToSelectedCellSelected(JTable table) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable t = clipboard.getContents(null);
            int selectedColumn = table.getSelectedColumn();
            int selectedRow = table.getSelectedRow();
            Object oldValue = table.getValueAt(selectedRow, selectedColumn);
            Object newValue = t.getTransferData(DataFlavor.stringFlavor);
            ResultSetTableModel model = (ResultSetTableModel)table.getModel();
            model.updateValueChanged(table,
                                     selectedRow,
                                     selectedColumn,
                                     oldValue,
                                     newValue);
            table.setValueAt(newValue, selectedRow, selectedColumn);
        } catch (UnsupportedFlavorException ex) {
            onError(ex);
        } catch (IOException ex) {
            onError(ex);
        } catch (SQLException ex) {
            onError(ex);
        }
    }

    /**
     * j["ׂđI"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuSelectAllSelected(JTable table) {
        table.selectAll();
    }

    /**
     * j["l̃NA"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuResetValueSelected(JTable table) {
        try {
            int selectedColumn = table.getSelectedColumn();
            int selectedRow = table.getSelectedRow();
            Object oldValue = table.getValueAt(selectedRow, selectedColumn);
            ResultSetTableModel model = (ResultSetTableModel)table.getModel();
            model.updateValueChanged(table,
                                     selectedRow,
                                     selectedColumn,
                                     oldValue,
                                     null);
            table.setValueAt(null, selectedRow, selectedColumn);
        } catch (SQLException ex) {
            onError(ex);
        }
    }

    /**
     * j["VKs}"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuAddNewRowSelected(JTable table) {
        ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        int rowCount = model.getRowCount();
        model.addRowAsInsert(new Object[model.getColumnCount()]);
        table.changeSelection(rowCount, 1, false, false);
    }

    /**
     * j["Rs[}"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuCopyInsertRowSelected(JTable table) {
        ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        int rowCount = model.getRowCount();
        int selectedRow = table.getSelectedRow();
        List row = (List)model.getDataVector().get(selectedRow);
        model.addRowAsInsert(row.toArray());
        table.changeSelection(rowCount, 1, false, false);
    }

    /**
     * j["Nbv{[h}"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuInsertClipboardDataelected(JTable table) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable t = clipboard.getContents(null);
            int columnCount = table.getColumnCount();
            Object value = t.getTransferData(DataFlavor.stringFlavor);
            ResultSetTableModel model = (ResultSetTableModel)table.getModel();
            Importer importer = new TabSeparatedTextImporter(String.valueOf(value));
            try {
                List errorList = new ArrayList();
                for (int rowIndex = table.getRowCount();; rowIndex++) {
                    Object[] row = importer.nextRow();
                    if (row.length == 0) {
                        break;
                    }
                    int size = Math.min(row.length, columnCount - 1);
                    Object[] insertData = new Object[size + 1];
                    System.arraycopy(row, 0, insertData, 1, size);
                    model.addRowAsInsert(insertData);
                    try {
                        model.updateRowInserted(table, rowIndex);
                    } catch (SQLException ex) {
                        log.warn("", ex);
                        errorList.add(ex);
                    }
                }
                if (!errorList.isEmpty()) {
                    String message = errorList.size() + " error(s) occurred";
                    DialogMessage.alert(table, message);
                }
            } finally {
                importer.close();
            }
        } catch (UnsupportedFlavorException ex) {
            onError(ex);
        } catch (IOException ex) {
            onError(ex);
        } catch (RuntimeException ex) {
            onError(ex);
        }
    }

    /**
     * j["}m"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuFixInsertSelected(JTable table) {
        try {
            ResultSetTableModel model = (ResultSetTableModel)table.getModel();
            model.updateRowInserted(table);
        } catch (SQLException ex) {
            onError(ex);
        } catch (RuntimeException ex) {
            onError(ex);
        }
    }

    /**
     * j["s폜"IꂽƂ̏B
     * @param table e[u
     */
    void onMenuDeleteRowSelected(JTable table) {
        ResultSetTableModel model = (ResultSetTableModel)table.getModel();
        int selectedRow = table.getSelectedRow();
        boolean isSelectedInsertRow = model.isInsertRow(selectedRow);
        if (!isSelectedInsertRow) {
            try {
                model.updateRowDeleted(table);
            } catch (SQLException ex) {
                onError(ex);
            }
        }
        model.removeRow(selectedRow);
    }

    /**
     * j["\[g"IꂽƂ̏B
     * @param table e[u
     * @param columnIndex I
     */
    void onMenuSortColumnSelected(JTable table, int columnIndex) {
        if (columnIndex >= 0) {
            ResultSetTable t = (ResultSetTable)table;
            t.requestSort(columnIndex);
        }
    }

    /**
     * j["I"IꂽƂ̏B
     * @param table e[u
     * @param columnIndex I
     */
    void onMenuSelectColumnSelected(JTable table, int columnIndex) {
        if (columnIndex >= 0) {
            ResultSetTable t = (ResultSetTable)table;
            t.selectColumn(columnIndex);
        }
    }

    /**
     * G[̏B
     * @param th O
     */
    void onError(Throwable th) {
        log.error("", th);
        DialogMessage.alert(parent, th.getMessage());
    }

    /**
     * (O)bZ[W̎擾B
     * @param key L[
     * @return bZ[W
     */
    private static String getMessage(String key) {
        return Messages.getString("menu.ContextMenu." + key);
    }

}