/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Environment;
import net.argius.stew.Launcher;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.MonospacedFontLookAndFeel;
import net.argius.stew.gui.WindowOutputProcessor;

public final class WindowLauncher
implements Launcher {
    private static final Logger log = LoggerFactory.getLogger(WindowLauncher.class);
    private final List opList;
    private int sequentialNumber;

    public WindowLauncher() {
        if (log.isInfoEnabled()) {
            log.info("initialize");
        }
        this.sequentialNumber = 1;
        this.opList = new LinkedList();
    }

    public void launch(Environment environment) {
        if (log.isInfoEnabled()) {
            log.info("launch");
        }
        WindowOutputProcessor windowOutputProcessor = new WindowOutputProcessor(environment, this);
        this.opList.add(windowOutputProcessor);
        ++this.sequentialNumber;
    }

    public void remove(WindowOutputProcessor windowOutputProcessor) {
        this.opList.remove(windowOutputProcessor);
    }

    void closeAll() {
        ArrayList arrayList = new ArrayList(this.opList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            WindowOutputProcessor windowOutputProcessor = (WindowOutputProcessor)arrayList.get(i);
            windowOutputProcessor.close();
        }
        arrayList.clear();
        if (log.isInfoEnabled()) {
            log.info("exit");
        }
    }

    int getSequentialNumber() {
        return this.sequentialNumber;
    }

    int getWindowCount() {
        return this.opList.size();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    System.setProperty("net.argius.stew.directory", "./");
                    MonospacedFontLookAndFeel.install();
                    WindowLauncher windowLauncher = new WindowLauncher();
                    windowLauncher.launch(new Environment());
                }
                catch (Throwable throwable) {
                    DialogMessage.alert(throwable.toString());
                }
            }
        });
    }
}

