/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.LocalSystem;
import net.argius.stew.StringClass;
import net.argius.stew.gui.NamedValue;

final class ResultSetTableMonitor {
    private static final Logger log = LoggerFactory.getLogger(ResultSetTableMonitor.class);
    private static final String PTN1 = "^.*\\s*SELECT\\s*.+\\s*FROM\\s*(.+)$";
    private static final String PROPERTY_TIMEOUT = ResultSetTableMonitor.class.getName() + ".timeout";
    private static final int TIMEOUT_DEFAULT = 10;
    private final int timeout;
    private boolean isUpdatable = false;
    private String tableName = "";
    private String[] primaryKeys = new String[0];
    private Connection conn;

    ResultSetTableMonitor() {
        int n;
        try {
            String string = LocalSystem.getProperty(PROPERTY_TIMEOUT);
            n = StringClass.isBlank(string) ? 10 : Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 10;
        }
        this.timeout = n;
    }

    synchronized void prepare(ResultSet resultSet, String string) throws SQLException {
        if (resultSet == null) {
            return;
        }
        Statement statement = resultSet.getStatement();
        if (statement == null) {
            return;
        }
        Connection connection = statement.getConnection();
        if (connection == null) {
            return;
        }
        if (connection.isReadOnly()) {
            return;
        }
        String string2 = ResultSetTableMonitor.findTableName(string);
        if (StringClass.isEmpty(string2)) {
            return;
        }
        String[] stringArray = ResultSetTableMonitor.findPrimaryKeys(connection, string2);
        if (stringArray.length < 1) {
            return;
        }
        this.tableName = string2;
        this.primaryKeys = stringArray;
        this.conn = connection;
        this.isUpdatable = true;
    }

    private static String findTableName(String string) {
        Pattern pattern;
        Matcher matcher;
        if (string != null && (matcher = (pattern = Pattern.compile(PTN1, 2)).matcher(string)).find()) {
            String string2;
            String string3 = matcher.group(1);
            String[] stringArray = string3.split("\\s");
            boolean bl = false;
            for (int i = 0; i < 2 && i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4.indexOf(44) < 0) continue;
                bl = true;
            }
            if (!bl && (string2 = stringArray[0]).matches("[A-Za-z0-9_]+")) {
                return string2;
            }
        }
        return "";
    }

    private static String[] findPrimaryKeys(Connection connection, String string) throws SQLException {
        String[] stringArray;
        String string2;
        String string3;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string4 = databaseMetaData.getUserName();
        if (string4 == null) {
            string4 = "";
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            string3 = string4.toLowerCase();
            string2 = string.toLowerCase();
        } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
            string3 = string4.toUpperCase();
            string2 = string.toUpperCase();
        } else {
            string3 = string4;
            string2 = string;
        }
        if (string2.indexOf(46) >= 0) {
            stringArray = string2.split("\\.");
            string3 = stringArray[0];
            string2 = stringArray[1];
        }
        if ((stringArray = ResultSetTableMonitor.getPrimaryKeys(databaseMetaData, string3, string2)).length > 0) {
            return stringArray;
        }
        return ResultSetTableMonitor.getPrimaryKeys(databaseMetaData, null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getPrimaryKeys(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, string, string2);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashSet<String> hashSet = new HashSet<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(4));
                hashSet.add(resultSet.getString(2));
            }
            if (hashSet.size() < 2) {
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                return stringArray;
            }
        }
        finally {
            resultSet.close();
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Map map, NamedValue namedValue) throws SQLException {
        this.checkConnection();
        String string = namedValue.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" SET ");
        stringBuffer.append(string);
        stringBuffer.append("=? WHERE ");
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this.primaryKeys[i]);
            stringBuffer.append("=?");
        }
        String string2 = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + string2);
            log.debug("parameter : " + namedValue);
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string2);
        try {
            int n;
            preparedStatement.setQueryTimeout(this.timeout);
            int n2 = 1;
            preparedStatement.setObject(n2++, namedValue.getValue());
            for (n = 0; n < this.primaryKeys.length; ++n) {
                preparedStatement.setObject(n2++, map.get(this.primaryKeys[n]));
            }
            n = preparedStatement.executeUpdate();
            this.checkUpdateCount(n);
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(Map map) throws SQLException {
        this.checkConnection();
        ArrayList arrayList = new ArrayList(map.keySet());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" (");
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
                stringBuffer2.append(',');
            }
            stringBuffer.append(arrayList.get(i));
            stringBuffer2.append('?');
        }
        stringBuffer.append(") VALUES (");
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(')');
        String string = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + string);
            log.debug("parameter : " + map);
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        try {
            int n2;
            preparedStatement.setQueryTimeout(this.timeout);
            int n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                preparedStatement.setObject(n2 + 1, map.get(arrayList.get(n2)));
            }
            n2 = preparedStatement.executeUpdate();
            this.checkUpdateCount(n2);
        }
        finally {
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(Map map) throws SQLException {
        this.checkConnection();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" WHERE ");
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this.primaryKeys[i]);
            stringBuffer.append("=?");
        }
        String string = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.debug("sql : " + string);
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        try {
            int n;
            preparedStatement.setQueryTimeout(this.timeout);
            for (n = 0; n < this.primaryKeys.length; ++n) {
                preparedStatement.setObject(n + 1, map.get(this.primaryKeys[n]));
            }
            n = preparedStatement.executeUpdate();
            this.checkUpdateCount(n);
        }
        finally {
            preparedStatement.close();
        }
    }

    private void checkConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw new SQLException("connection is already closed");
        }
    }

    private void checkUpdateCount(int n) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("updated count = " + n);
        }
        if (n != 1) {
            throw new SQLException("incorrect count : " + n);
        }
    }

    boolean isUpdatable() {
        return this.isUpdatable;
    }

    String getTableName() {
        return this.tableName;
    }

    String[] getPrimaryKeys() {
        return (String[])this.primaryKeys.clone();
    }
}

