/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.argius.stew.gui.FlexibleDialogBase;
import net.argius.stew.gui.FormedFont;
import net.argius.stew.gui.Messages;

public final class FontChooser {
    private static final Font DEFAULT = FormedFont.Regular;
    private static final Object[] FAMILIES = new Object[]{"Sans-Serif", "Serif", "Monospaced"};
    private final List listeners;
    private final JComboBox tFamily;
    private final JSpinner sSize;
    private final JTextField tSample;
    private FlexibleDialogBase dialog;
    private Font currentFont = DEFAULT;

    public FontChooser() throws HeadlessException {
        this.listeners = new ArrayList();
        this.tFamily = new JComboBox<Object>(FAMILIES);
        int n = this.currentFont.getSize();
        this.sSize = new JSpinner(new SpinnerNumberModel(n, 6, 32, 1));
        this.tSample = new JTextField(FontChooser.getMessage("sample"));
        this.tFamily.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.onValueChanged(actionEvent);
            }
        });
        this.sSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FontChooser.this.onValueChanged(changeEvent);
            }
        });
    }

    public Font getCurrentFont() {
        return this.currentFont;
    }

    public void setCurrentFont(Font font) {
        this.currentFont = font;
    }

    void showDialog(Frame frame) {
        String string = this.currentFont.getFamily();
        int n = this.currentFont.getSize();
        this.dialog = new FlexibleDialogBase(frame){};
        this.tFamily.setEditable(true);
        this.tFamily.setSelectedItem(string);
        this.dialog.addComponent(this.tFamily, false);
        this.sSize.setValue(new Integer(n));
        this.dialog.addComponent(this.sSize, true);
        this.dialog.addComponent(this.tSample, true);
        this.tSample.setFont(this.currentFont);
        this.tSample.updateUI();
        JButton jButton = new JButton(FontChooser.getMessage("submit"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.onButtonSubmitClicked();
            }
        });
        this.dialog.addComponent(jButton, false);
        JButton jButton2 = new JButton(FontChooser.getMessage("reset"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.onButtonResetClicked();
            }
        });
        this.dialog.addComponent(jButton2, false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(frame);
        this.dialog.setVisible(true);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireFontChanged() {
        this.currentFont = this.tSample.getFont();
        ChangeEvent changeEvent = new ChangeEvent(this.currentFont);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ChangeListener changeListener = (ChangeListener)this.listeners.get(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    void onValueChanged(EventObject eventObject) {
        int n;
        Serializable serializable;
        String string = String.valueOf(this.tFamily.getSelectedItem());
        Object object = this.sSize.getValue();
        if (object instanceof Integer) {
            serializable = (Integer)object;
            n = serializable;
        } else {
            n = this.currentFont.getSize();
        }
        serializable = new Font(string, 0, n);
        this.tSample.setFont((Font)serializable);
        this.dialog.pack();
    }

    void onButtonSubmitClicked() {
        this.fireFontChanged();
        this.dialog.dispose();
        this.dialog = null;
    }

    void onButtonResetClicked() {
        Font font = DEFAULT;
        this.tFamily.setSelectedItem(font.getFamily());
        this.sSize.setValue(new Integer(font.getSize()));
        this.onValueChanged(new ChangeEvent(font));
    }

    private static String getMessage(String string) {
        return Messages.getString("dialog.FontChooser." + string);
    }
}

