/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;
import net.argius.stew.io.Importer;
import net.argius.stew.io.Path;

public class Load
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Load.class);
    private static final String USAGE = Load.getUsage("load");

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(USAGE);
        }
        int n = 2;
        String string = parameter.get(n++);
        if (log.isDebugEnabled()) {
            log.debug("file : " + string);
        }
        try {
            Path path = Path.resolve(this.env.getCurrentDirectory(), string);
            if (parameter.isEmpty(3)) {
                this.loadSql(connection, path);
            } else {
                String string2 = parameter.get(n++);
                String string3 = parameter.get(n++);
                boolean bl = string3.equalsIgnoreCase("header");
                this.loadRecord(connection, path, string2, bl);
            }
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSql(Connection connection, File file) throws IOException, SQLException {
        block13: {
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            FileReader fileReader = new FileReader(file);
            try {
                int n;
                while ((n = fileReader.read(cArray)) >= 0) {
                    stringBuffer.append(cArray, 0, n);
                }
            }
            finally {
                fileReader.close();
            }
            String string = stringBuffer.toString();
            if (log.isDebugEnabled()) {
                log.debug("sql : " + string);
            }
            Statement statement = connection.createStatement();
            try {
                if (Load.isSelect(string)) {
                    ResultSet resultSet = statement.executeQuery(string);
                    try {
                        ResultSetReference resultSetReference = new ResultSetReference(resultSet);
                        this.output(resultSetReference);
                        Object[] objectArray = new Object[]{new Integer(resultSetReference.getRecordCount())};
                        this.outputMessage(".selected", objectArray);
                        break block13;
                    }
                    finally {
                        resultSet.close();
                    }
                }
                int n = statement.executeUpdate(string);
                Object[] objectArray = new Object[]{new Integer(n)};
                this.outputMessage(".proceeded", objectArray);
            }
            finally {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRecord(Connection connection, File file, String string, boolean bl) throws IOException, SQLException {
        Importer importer = Importer.getImporter(file);
        try {
            int n;
            Object[] objectArray;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(" (");
                objectArray = importer.nextRow();
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(objectArray[n]);
                }
                stringBuffer.append(')');
            } else {
                Importer importer2 = Importer.getImporter(file);
                try {
                    objectArray = importer2.nextRow();
                }
                finally {
                    importer2.close();
                }
            }
            stringBuffer.append(" VALUES (");
            for (n = 0; n < objectArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('?');
            }
            stringBuffer.append(')');
            String string2 = stringBuffer.toString();
            if (log.isDebugEnabled()) {
                log.debug("SQL : " + string2);
            }
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            try {
                this.insertRecords(preparedStatement, importer);
            }
            finally {
                preparedStatement.close();
            }
        }
        finally {
            importer.close();
        }
    }

    protected void insertRecords(PreparedStatement preparedStatement, Importer importer) throws IOException, SQLException {
        Object[] objectArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((objectArray = importer.nextRow()) != null && objectArray.length != 0) {
            ++n;
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    int n4 = i + 1;
                    Object object = objectArray[i];
                    preparedStatement.setObject(n4, object);
                }
                n2 += preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                String string = "error occurred at " + n;
                if (log.isTraceEnabled()) {
                    log.trace(string, sQLException);
                } else if (log.isDebugEnabled()) {
                    log.debug(string + " : " + sQLException);
                }
                ++n3;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("record   = " + n);
            log.debug("inserted = " + n2);
            log.debug("error    = " + n3);
        }
        objectArray = new Object[]{new Integer(n2), new Integer(n)};
        this.outputMessage(".loaded", objectArray);
    }
}

