/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;

public final class Count
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Count.class);
    private static final String USAGE = Count.getUsage("count");

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(USAGE);
        }
        String string = parameter.getAll(2);
        String string2 = "SELECT COUNT(*) FROM " + string;
        if (log.isDebugEnabled()) {
            log.debug("SQL : " + string2);
        }
        try {
            this.execute(connection, string2);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            this.setTimeout(statement);
            ResultSet resultSet = statement.executeQuery(string);
            try {
                resultSet.next();
                Object[] objectArray = new Object[]{new Integer(resultSet.getInt(1))};
                this.outputMessage(".selected", objectArray);
            }
            finally {
                resultSet.close();
            }
        }
        finally {
            statement.close();
        }
    }
}

