package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;
import net.argius.frui.io.*;

/**
 * ֈړ鏈B
 */
public final class Waste implements Operation {

    private final WasteBasket wasteBasket;

    /**
     * Waste̐B
     */
    public Waste() {
        String waste = Environment.getProperty("waste");
        wasteBasket = new WasteBasket(waste);
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (!file.isDirectory() && !file.isAbsolute()) {
            File newPath = new File(wasteBasket.getDirectory(), file.getPath());
            File newFile = newPath.getCanonicalFile();
            if (IOUtilities.move(file, newFile, false)) {
                fileInfo.setFile(newFile);
                return true;
            }
        }
        return false;
    }

}