package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;
import net.argius.frui.io.*;

/**
 * t@CTCY̊NXB
 * Ώۃt@CTCY擾A
 * wTCYƂ̔r͎NXɔCB
 * fBNg͏ɁuYvƂȂB
 */
public abstract class Size extends Condition {

    private final long value;

    /**
     * Size̐B
     * @param value TCYioCgj
     */
    protected Size(long value) {
        this(value, "");
    }

    /**
     * Size̐B
     * @param value TCYioCgj
     * @param expression TCYw蕶
     */
    protected Size(long value, String expression) {
        super(editSizeExpression(value, expression), false);
        this.value = value;
    }

    /**
     * TCY\L̕ҏWB
     * @param value TCYioCgj
     * @param expression TCYw蕶
     * @return TCY\L
     */
    private static String editSizeExpression(long value, String expression) {
        StringBuffer buffer = new StringBuffer();
        final int firstIndex = Character.isDigit(expression.charAt(0)) ? 0 : 1;
        buffer.append(expression.substring(firstIndex));
        if (!String.valueOf(value).equals(expression)) {
            buffer.append('=').append(value);
        }
        buffer.append("bytes");
        return buffer.toString();
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return false;
        }
        return isNegative != compare(value, file.length());
    }

    /**
     * t@CTCYrB
     * @param size wTCY
     * @param fileSize t@CTCY
     * @return TCY̊֌W𖞂ꍇ <code>true</code>A
     *         łȂꍇ <code>false</code>
     */
    protected abstract boolean compare(long size, long fileSize);

    /**
     * CX^X擾B
     * @param expression TCYw蕶
     * @return CX^X
     */
    public static Size getInstance(String expression) {
        return parseExpression(expression);
    }

    /**
     * w蕶͂B
     * @param expression w蕶
     * @return CX^X
     */
    private static Size parseExpression(String expression) {
        int firstIndex = 0;
        char firstChar = expression.charAt(0);
        if (!Character.isDigit(firstChar)) {
            ++firstIndex;
        }
        long value = FileSize.toLong(expression.substring(firstIndex));
        if (firstChar == '+') {
            return new MinLimit(value, expression);
        }
        if (firstChar == '-') {
            return new MaxLimit(value, expression);
        }
        if (firstChar == '=' || Character.isDigit(firstChar)) {
            return new Equal(value, expression);
        }
        throw new IllegalOperationException(IllegalOperationException.EXPRESSION, expression);
    }

    /**
     * TCYB
     */
    public static final class Equal extends Size {

        /**
         * Equal̐B
         * @param size TCY
         * @param expression TCYw蕶
         */
        public Equal(long size, String expression) {
            super(size, expression);
        }

        /* (overridden)
         * @see net.argius.frui.operation.Size#compare(long, long)
         */
        protected boolean compare(long size, long fileSize) {
            return fileSize == size;
        }

    }

    /**
     * TCYB 
     */
    public static final class MaxLimit extends Size {

        /**
         * MaxLimit̐B
         * @param size TCY
         * @param expression TCYw蕶
         */
        public MaxLimit(long size, String expression) {
            super(size, expression);
        }

        /* (overridden)
         * @see net.argius.frui.operation.Size#compare(long, long)
         */
        protected boolean compare(long size, long fileSize) {
            return fileSize <= size;
        }

    }

    /**
     * TCYB
     */
    public static final class MinLimit extends Size {

        /**
         * MinLimit̐B
         * @param size TCY
         * @param expression TCYw蕶
         */
        public MinLimit(long size, String expression) {
            super(size, expression);
        }

        /* (overridden)
         * @see net.argius.frui.operation.Size#compare(long, long)
         */
        protected boolean compare(long size, long fileSize) {
            return fileSize >= size;
        }

    }

}