package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;
import net.argius.frui.io.*;
import net.argius.frui.text.*;

/**
 * pX̒uɂړB
 * wp^[܂ރpX̏ꍇA
 * up^[ɂăpXuA
 * ũpXɈړit@CύXjB
 * p^[Ɉv_ŁuYvƂȂB
 * ̏ꍇAړɐꍇ͒ũpX
 * t@CɃZbgB
 * fBNg͏ɁuYvƂȂB
 */
public class Move implements Operation {

    private final Pattern pattern;
    private final String patternString;
    private final String replaceString;
    private final File backupDirectory;
    private final boolean isIgnoreCase;

    /**
     * Move̐B
     * @param patternString vp^[
     * @param replaceString up^[
     */
    public Move(String patternString, String replaceString) {
        this(patternString, replaceString, false);
    }

    /**
     * Move̐B
     * @param patternString vp^[
     * @param replaceString up^[
     * @param isIgnoreCase 啶𖳎ꍇ <code>true</code>
     */
    public Move(String patternString, String replaceString, boolean isIgnoreCase) {
        Utilities.checkModifiable();
        this.pattern = PatternFactory.create(patternString, isIgnoreCase);
        this.patternString = patternString;
        this.replaceString = replaceString;
        this.backupDirectory = Utilities.createTemporaryDirectory();
        this.isIgnoreCase = isIgnoreCase;
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (isIgnoreCase) {
            buffer.append('i');
        }
        buffer.append(Utilities.getSimpleClassName(getClass()));
        buffer.append('(');
        buffer.append(patternString);
        buffer.append(',');
        buffer.append(replaceString);
        buffer.append(')');
        return buffer.toString();
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return false;
        }
        String path = file.toString();
        if (pattern.find(path)) {
            String replaced = Utilities.replaceAll(pattern, path, replaceString);
            File newFile = new File(replaced);
            IOUtilities.copy(file, new File(backupDirectory, file.getPath()));
            if (doMove(file, newFile)) {
                fileInfo.setFile(newFile);
            }
            return true;
        }
        return false;
    }

    /**
     * t@CړB
     * @param file t@C
     * @param newFile ړt@C
     * @return ړɐꍇ <code>true</code>
     *               sꍇ <code>false</code>
     * @throws IOException o̓G[ꍇ
     */
    protected boolean doMove(File file, File newFile) throws IOException {
        return IOUtilities.move(file, newFile, false);
    }

}