package net.argius.frui.io;

import java.math.*;

/**
 * t@CTCYB
 */
public final class FileSize {

    /**
     * FileSize̐B
     */
    private FileSize() {
        // empty
    }

    /**
     * <code>ubN</code>
     */
    public static final int BLOCK = 512;

    /**
     * <code>L</code>
     */
    public static final int K = 1000;

    /**
     * <code>LoCg</code>
     */
    public static final int KB = 1024;

    /**
     * t@CTCYlonglɕϊB
     * <code>long</code> ̏𒴂8EBȏ̓G[B
     * @param expression \L
     * @return t@CTCY
     * @throws IllegalArgumentException \LsK̏ꍇ 
     */
    public static long toLong(String expression) {
        int pointCount = 0;
        int pointIndex = -1;
        for (int p = 0, n = expression.length(); p < n; p++) {
            char c = expression.charAt(p);
            if (c == '.') {
                ++pointCount;
                pointIndex = p;
                if (pointCount > 1) {
                    break;
                }
            } else if (!Character.isDigit(c)) {
                if (p == 0) {
                    throw new IllegalArgumentException("invalid expression: "
                                                       + expression);
                }
                String sizeString = expression.substring(0, p);
                String unit = expression.substring(p);
                double number = Double.parseDouble(sizeString);
                boolean isBlock = unit.equalsIgnoreCase("b");
                boolean isSIUnit = !isBlock
                                   && !unit.substring(unit.length() - 1)
                                           .equalsIgnoreCase("B");
                int multiplier = (isBlock) ? 0 : getMultiplier(unit);
                if (number >= Integer.MAX_VALUE || multiplier > 3) {
                    double trial;
                    if (isBlock) {
                        trial = number * BLOCK;
                    } else {
                        trial = number;
                        for (int i = 0; i < multiplier; i++) {
                            trial *= (isSIUnit) ? K : KB;
                        }
                    }
                    if (trial >= Long.MAX_VALUE) {
                        throw new IllegalArgumentException("size too large: "
                                                           + trial);
                    }
                }
                if (pointCount == 0) {
                    long value = Long.parseLong(sizeString);
                    if (isBlock) {
                        return value * BLOCK;
                    }
                    for (int i = 0; i < multiplier; i++) {
                        value *= (isSIUnit) ? K : KB;
                    }
                    return value;
                } else if (pointCount == 1) {
                    BigDecimal bd = new BigDecimal(sizeString);
                    if (isBlock) {
                        return bd.multiply(BigDecimal.valueOf(BLOCK))
                                 .longValue();
                    }
                    for (int i = 0; i < multiplier; i++) {
                        bd = bd.multiply(BigDecimal.valueOf(isSIUnit ? K : KB));
                    }
                    return bd.longValue();
                }
            }
        }
        if (pointCount == 0) {
            return Long.parseLong(expression);
        } else if (pointCount == 1 && pointIndex >= 1) {
            // _ȉSă[Ȃ琮Ƃ݂Ȃ
            String decimal = expression.substring(pointIndex + 1);
            final int length = decimal.length();
            if (length > 0) {
                int count = 0;
                for (int i = 0; i < length; i++) {
                    if (decimal.charAt(i) == '0') {
                        ++count;
                    }
                }
                if (count == length) {
                    return Long.parseLong(expression.substring(0, pointIndex));
                }
            }
        }
        throw new IllegalArgumentException("invalid expression: " + expression);
    }

    /**
     * 搔̎擾B
     * @param unit P
     * @return 搔
     */
    private static int getMultiplier(String unit) {
        final String uc = unit.toUpperCase();
        if (uc.equals("K") || uc.equals("KB")) {
            return 1;
        } else if (uc.equals("M") || uc.equals("MB")) {
            return 2;
        } else if (uc.equals("G") || uc.equals("GB")) {
            return 3;
        } else if (uc.equals("T") || uc.equals("TB")) {
            return 4;
        } else if (uc.equals("P") || uc.equals("PB")) {
            return 5;
        } else if (uc.equals("E") || uc.equals("EB")) {
            return 6;
        } else if (uc.equals("Z") || uc.equals("ZB")) {
            return 7;
        } else if (uc.equals("Y") || uc.equals("YB")) {
            return 8;
        }
        throw new IllegalArgumentException("invalid unit: " + uc);
    }

}
