package net.argius.frui.text;

import java.text.*;
import java.util.*;

import net.argius.frui.*;

/**
 * JnƏI̎_B
 */
public final class TimePoints {

    private static final String[] TIME_FORMATS = {"yyyyMMdd", "yyyyMMddHH",
                                                  "yyyyMMddHHmm",
                                                  "yyyyMMddHHmmss"};
    private static final int[] TIME_UNITS = {Calendar.DATE,
                                             Calendar.HOUR_OF_DAY,
                                             Calendar.MINUTE, Calendar.SECOND,
                                             Calendar.MILLISECOND};

    private final long startPoint;
    private final long endPoint;

    /**
     * TimePoints̐B
     * @param startPoint Jn_
     * @param endPoint I_
     * @exception IllegalOperationException
     * Jn_ƏI_̊֌WȂꍇ
     */
    public TimePoints(long startPoint, long endPoint) {
        if (startPoint > endPoint) {
            throw new IllegalOperationException(IllegalOperationException.EXPRESSION,
                                                "start("
                                                        + startPoint
                                                        + ") > end("
                                                        + endPoint
                                                        + ")");
        }
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    /**
     * TimePoints̐B
     * @param expression \
     * @throws IllegalOperationException \Ȃꍇ
     */
    public TimePoints(String expression) {
        int index = 0;
        // sign
        char sign = expression.charAt(index);
        switch (sign) {
            case '+':
            case ']':
            case '=':
            case '[':
            case '-':
                ++index;
                break;
            default:
                sign = '=';
        }
        // type
        int lastIndex = expression.length() - 1;
        char lastChar = expression.charAt(lastIndex);
        boolean lastCharIsDigit = Character.isDigit(lastChar);
        if (lastCharIsDigit) {
            ++lastIndex;
        }
        // parse
        String value = expression.substring(index, lastIndex);
        long point1;
        long point2;
        try {
            Calendar calendar = Calendar.getInstance();
            int field;
            if (lastCharIsDigit && value.length() > 7) {
                field = parseAbsoluteTime(calendar, value);
            } else {
                char unit = (lastCharIsDigit) ? 'd' : lastChar;
                field = parseRelativeTime(calendar, value, unit);
            }
            point1 = calendar.getTime().getTime();
            calendar.add(field, +1);
            point2 = calendar.getTime().getTime();
        } catch (ParseException ex) {
            throw new IllegalOperationException(IllegalOperationException.EXPRESSION,
                                                "",
                                                ex);
        }
        // choice
        switch (sign) {
            case '+':
                startPoint = 0L;
                endPoint = point1 - 1L;
                break;
            case ']':
                startPoint = 0L;
                endPoint = point2 - 1L;
                break;
            case '=':
                startPoint = point1;
                endPoint = point2 - 1L;
                break;
            case '-':
                startPoint = point2;
                endPoint = Long.MAX_VALUE;
                break;
            case '[':
                startPoint = point1;
                endPoint = Long.MAX_VALUE;
                break;
            default:
                throw new IllegalArgumentException(expression);
        }
    }

    /**
     * Ύw莞߂B
     * @param calendar Calendar
     * @param value 
     * @return ̒P
     * @throws ParseException ͂Ɏsꍇ
     */
    private int parseAbsoluteTime(Calendar calendar, String value) throws ParseException {
        for (int i = 0; i < TIME_FORMATS.length; i++) {
            String formatString = TIME_FORMATS[i];
            if (value.length() == formatString.length()) {
                DateFormat format = new SimpleDateFormat(formatString);
                calendar.setTime(format.parse(value));
                return TIME_UNITS[i];
            }
        }
        throw new ParseException("illegal expression : " + value, -1);
    }

    /**
     * Ύw莞߂B
     * @param calendar calendar
     * @param amountString Ύԗ
     * @param unit ԒP
     * @return ̒P
     * @throws ParseException ͂Ɏsꍇ
     */
    private int parseRelativeTime(Calendar calendar,
                                  String amountString,
                                  char unit) throws ParseException {
        int amount = Integer.parseInt(amountString);
        int fieldIndex;
        switch (Character.toLowerCase(unit)) {
            case 'd':
                fieldIndex = 0;
                break;
            case 'h':
                fieldIndex = 1;
                break;
            case 'm':
                fieldIndex = 2;
                break;
            case 's':
                fieldIndex = 3;
                break;
            default:
                throw new ParseException("unit : " + unit, -1);
        }
        for (int i = fieldIndex + 1; i < TIME_UNITS.length; i++) {
            calendar.set(TIME_UNITS[i], 0);
        }
        int field = TIME_UNITS[fieldIndex];
        calendar.add(field, -amount);
        return field;
    }

    /**
     * n_̎擾B
     * @return n_
     */
    public long getStartPoint() {
        return startPoint;
    }

    /**
     * I_̎擾B
     * @return I_
     */
    public long getEndPoint() {
        return endPoint;
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd_HH:mm:ss:SSS");
        if (startPoint > 0L) {
            buffer.append(dateFormat.format(new Date(startPoint)));
        }
        buffer.append('-');
        if (endPoint < Long.MAX_VALUE) {
            buffer.append(dateFormat.format(new Date(endPoint)));
        }
        return buffer.toString();
    }

}