/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.IOException;
import net.argius.frui.Environment;
import net.argius.frui.FileInfo;
import net.argius.frui.Operation;
import net.argius.frui.operation.Utilities;

public abstract class Print
implements Operation {
    private final boolean useTrimPath = Environment.getBooleanProperty("path.trim");
    private final boolean useReplaceSeparator;
    private final char plainSeparator = File.separatorChar;
    private final char newSeparator;

    public Print() {
        String string = Environment.getProperty("path.separator");
        if (string.length() == 1 && !string.equals(File.separator)) {
            this.newSeparator = string.charAt(0);
            this.useReplaceSeparator = true;
        } else {
            this.newSeparator = this.plainSeparator;
            this.useReplaceSeparator = false;
        }
    }

    public void printMessage(String string) {
        System.err.println(string);
    }

    public void printError(String string, Throwable throwable) {
        System.err.println(string);
        if (Environment.getBooleanProperty("debug")) {
            throwable.printStackTrace();
        }
    }

    protected final String padInt(int n) {
        String string = String.valueOf(n);
        return "          ".substring(string.length()) + string;
    }

    protected final String padLong(long l) {
        String string = String.valueOf(l);
        return "                   ".substring(string.length()) + string;
    }

    protected void print(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            char[] cArray = file.getPath().toCharArray();
            int n = cArray.length;
            int n2 = 0;
            if (this.useTrimPath && !file.isAbsolute() && n >= 2 && cArray[0] == '.' && cArray[1] == this.plainSeparator) {
                n2 = 2;
                n -= 2;
            }
            if (this.useReplaceSeparator) {
                for (int i = n2; i < n; ++i) {
                    if (cArray[i] != this.plainSeparator) continue;
                    cArray[i] = this.newSeparator;
                }
            }
            System.out.print(new String(cArray, n2, n));
        } else {
            System.out.print(object);
        }
    }

    protected void println() {
        System.out.println();
    }

    protected void println(Object object) {
        this.print(object);
        System.out.println();
    }

    public String toString() {
        return Utilities.getSimpleClassName(this.getClass());
    }

    public boolean operate(FileInfo fileInfo) throws IOException {
        this.printInfo(fileInfo);
        return false;
    }

    protected abstract void printInfo(FileInfo var1) throws IOException;
}

