/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.argius.frui.io.CharSequenceFIFO;

public final class LineReader
extends BufferedReader {
    private static final String EMPTY_STRING = "";
    private Reader in;
    private boolean skipLF;
    private int lineNumber;
    private String lineSeparator;
    private CharSequenceFIFO buffer;

    public LineReader(Reader reader) {
        super(reader, 1);
        this.in = reader;
        this.lineNumber = 0;
        this.lineSeparator = EMPTY_STRING;
        this.buffer = new CharSequenceFIFO(8192);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("stream is closed");
        }
    }

    public void close() throws IOException {
        this.in = null;
        this.buffer = null;
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char c;
            this.ensureOpen();
            if (this.buffer.length() <= 0) {
                int n = this.in.read();
                if (n <= 0) {
                    return -1;
                }
                c = (char)n;
            } else {
                c = this.buffer.draw(1).charAt(0);
            }
            switch (c) {
                case '\r': {
                    this.skipLF = true;
                    ++this.lineNumber;
                    this.lineSeparator = this.lineSeparator + c;
                    break;
                }
                case '\n': {
                    if (!this.skipLF) {
                        ++this.lineNumber;
                    }
                    this.skipLF = false;
                    this.lineSeparator = this.lineSeparator + c;
                    break;
                }
                default: {
                    this.lineSeparator = EMPTY_STRING;
                }
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n2 == 0) {
                return 0;
            }
            int n3 = n2;
            if (this.buffer.length() <= 0) {
                int n4 = this.readChars(cArray, n, n2);
                if (n4 <= 0) {
                    return -1;
                }
                if (n4 < n2) {
                    n3 = n4;
                }
            }
            CharSequence charSequence = this.buffer.draw(n3);
            int n5 = charSequence.length();
            block7: for (int i = 0; i < n5; ++i) {
                char c;
                cArray[n + i] = c = charSequence.charAt(i);
                switch (c) {
                    case '\r': {
                        this.skipLF = true;
                        ++this.lineNumber;
                        this.lineSeparator = this.lineSeparator + c;
                        continue block7;
                    }
                    case '\n': {
                        if (!this.skipLF) {
                            ++this.lineNumber;
                            this.skipLF = false;
                        }
                        this.lineSeparator = this.lineSeparator + c;
                        continue block7;
                    }
                    default: {
                        this.lineSeparator = EMPTY_STRING;
                    }
                }
            }
            return n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n = 0;
            while (this.buffer.length() > n || this.readChars() > 0) {
                int n2;
                int n3 = 0;
                int n4 = this.buffer.indexOf('\r', n);
                int n5 = this.buffer.indexOf('\n', n);
                if (n4 >= 0 && n5 >= 0) {
                    ++n3;
                    if (n4 < n5) {
                        if (n4 + 1 == n5) {
                            n2 = n5;
                            ++n3;
                        } else {
                            n2 = n4;
                        }
                    } else {
                        n2 = n5;
                    }
                } else if (n4 >= 0) {
                    n2 = n4;
                    ++n3;
                } else if (n5 >= 0) {
                    n2 = n5;
                    ++n3;
                } else {
                    n = this.buffer.length();
                    continue;
                }
                CharSequence charSequence = this.buffer.draw(n2 + 1);
                int n6 = charSequence.length();
                if (n6 <= 0) break;
                int n7 = n6 - n3;
                this.skipLF = false;
                ++this.lineNumber;
                this.lineSeparator = ((Object)charSequence).toString().substring(n7);
                return ((Object)charSequence.subSequence(0, n7)).toString();
            }
            if (this.buffer.length() > 0) {
                this.skipLF = false;
                ++this.lineNumber;
                this.lineSeparator = EMPTY_STRING;
                return ((Object)this.buffer.draw()).toString();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readChars() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            char[] cArray = new char[1024];
            int n = this.in.read(cArray);
            if (n > 0) {
                this.buffer.add(cArray, 0, n);
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readChars(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n3 = this.in.read(cArray, n, n2);
            if (n3 > 0) {
                this.buffer.add(cArray, n, n3);
            }
            return n3;
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }
}

