package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;
import net.argius.frui.text.*;

/**
 * t@CŏIXV B
 * ŏIXVQ̎_̊ԂɂꍇAuYvƂȂB
 */
public final class Time extends Condition {

    private final TimePoints timePoints;

    /**
     * Time̐B
     * @param expression \
     */
    public Time(String expression) {
        timePoints = new TimePoints(expression);
    }

    /* (overridden)
     * @see net.argius.frui.operation.Condition#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (isNegative) {
            buffer.append(Constants.LABEL_NOT);
        }
        buffer.append(Utilities.getSimpleClassName(getClass()));
        buffer.append('(');
        buffer.append(timePoints);
        buffer.append(')');
        return buffer.toString();
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        long lastModified = fileInfo.getFile().lastModified();
        return (timePoints.getStartPoint() <= lastModified && lastModified <= timePoints.getEndPoint());
    }

}