package net.argius.frui.operation;

import java.io.*;
import java.util.*;

import net.argius.frui.*;

/**
 * HTML`ŏo͂鏈B
 * o͌`̎B
 */
public final class PrintHTML extends Print {

    private final String title;

    private boolean first;

    /**
     * PrintHTML̐B
     * @param args R}hC
     */
    public PrintHTML(String[] args) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; i++) {
            buffer.append(args[i]);
            buffer.append(' ');
        }
        this.title = buffer.toString();
        this.first = true;
    }

    /* (overridden)
     * @see net.argius.frui.operation.Print#printResult(net.argius.frui.FileInfo)
     */
    protected void printInfo(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        List lineInfoList = fileInfo.getLineInfoList();
        if (first) {
            println("<title>" + title + "</title>");
            println("<h1>" + title + "</h1>");
            first = false;
        }
        print("<li><a href=\"");
        print(file);
        print("\">");
        print(file);
        print("</a>");
        if (lineInfoList != null && !lineInfoList.isEmpty()) {
            println("<ul>");
            for (int i = 0, n = lineInfoList.size(); i < n; i++) {
                LineInfo lineInfo = (LineInfo)lineInfoList.get(i);
                print("<li>" + lineInfo + "</li>");
            }
            println("</ul>");
        }
        println("</li>");
    }

}