package net.argius.frui.operation;

import java.io.*;
import java.lang.reflect.*;
import java.util.*;

import net.argius.frui.*;

/**
 * Cӂ̃IvVs鏈B
 * SC̏ꍇ͂̃NXA
 * łȂꍇ́ĩNXƁjpbP[W̃NXĂяoB
 * ĂяoNX <code>Operation</code>C^tF[X
 * ĂKvB
 */
public final class Evaluate implements Operation {

    private Operation operation;

    /**
     * Evaluate̐B
     * @param name IvV
     * @param arguments 
     */
    public Evaluate(String name, String[] arguments) {
        try {
            Class targetClass;
            try {
                targetClass = lookup(name);
            } catch (ClassNotFoundException ex1) {
                targetClass = lookup(name);
            }
            if (targetClass == Evaluate.class) {
                // g͏łȂ
                throw new IllegalOperationException(IllegalOperationException.EXPRESSION,
                                                    "circular reference");
            }
            int size = arguments.length;
            if (size > 0) {
                Class[] types = new Class[size];
                Arrays.fill(types, String.class);
                Constructor ctor = targetClass.getConstructor(types);
                operation = (Operation)ctor.newInstance(arguments);
            } else {
                operation = (Operation)targetClass.newInstance();
            }
        } catch (ClassCastException ex) {
            // ̎ł͂Ȃ
            throwRuntimeError(name, ex);
        } catch (ClassNotFoundException ex) {
            // NXȂ
            throwRuntimeError(name, ex);
        } catch (InstantiationException ex) {
            // IuWFNgɎs
            throwRuntimeError(name, ex);
        } catch (IllegalAccessException ex) {
            // sȃANZX
            throwRuntimeError(name, ex);
        } catch (NoSuchMethodException ex) {
            // `̑
            throwRuntimeError(name, ex);
        } catch (InvocationTargetException ex) {
            // RXgN^NłȂ
            throwRuntimeError(name, ex);
        }
    }

    /**
     * sG[X[B
     * @param name NX
     * @param th O
     */
    private void throwRuntimeError(String name, Throwable th) {
        String message = th.toString() + Constants.MESSAGE_SEPARATOR + name;
        throw new IllegalOperationException(IllegalOperationException.RUNTIME,
                                            message,
                                            th);
    }

    /**
     * ΏۃNXTB
     * @param name IvV
     * @return ΏۃNX
     * @throws ClassNotFoundException ΏۃNXȂꍇ
     */
    private Class lookup(String name) throws ClassNotFoundException {
        String className;
        if (name.indexOf('.') >= 0) {
            className = name;
        } else {
            className = getClass().getPackage().getName() + '.' + name;
        }
        return Class.forName(className);
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Utilities.getSimpleClassName(getClass()));
        buffer.append('(');
        buffer.append(operation);
        buffer.append(')');
        return buffer.toString();
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        return operation.operate(fileInfo);
    }

}