package net.argius.frui.io;

import java.io.*;
import java.util.*;

import net.argius.frui.*;
import net.argius.frui.text.*;

/**
 * Findpt@CtB^̎B
 * gq[hEʏiK\j[hT|[gB
 */
public final class FindFileFilter implements FileFilter {

    private final Pattern pattern;
    private final boolean separatorReplace;

    private char oldSeparator;
    private char newSeparator;

    /**
     * FindFileFilter̐B
     * @param expression p^[\
     */
    public FindFileFilter(String expression) {
        this(expression, false);
    }

    /**
     * FindFileFilter̐B
     * @param expression p^[\
     * @param isIgnoreCase 啶𖳎ꍇ <code>true</code>
     */
    public FindFileFilter(String expression, boolean isIgnoreCase) {
        // p^[
        if (expression.startsWith(".")) {
            StringMatcher m = new StringMatcher(",");
            pattern = new SuffixMatcher(m.split(expression.substring(1)));
        } else {
            pattern = PatternFactory.create(expression, isIgnoreCase);
        }
        // pXZp[^
        String replaceSeparator = Environment.getProperty("path.separator");
        if (replaceSeparator.length() == 1
            && !replaceSeparator.equals(File.separator)) {
            oldSeparator = File.separatorChar;
            newSeparator = replaceSeparator.charAt(0);
            separatorReplace = true;
        } else {
            separatorReplace = false;
        }
    }

    /* (overridden)
     * @see java.io.FileFilter#accept(java.io.File)
     */
    public boolean accept(File pathname) {
        String path = pathname.getPath();
        if (separatorReplace) {
            path = path.replace(oldSeparator, newSeparator);
        }
        return pattern.find(path);
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return pattern.pattern();
    }

    /**
     * gqp^[}b`B
     */
    private static final class SuffixMatcher implements Pattern {

        private final String[] suffixes;

        /**
         * SuffixMatcher̐B
         * @param suffixes gq̔z
         */
        public SuffixMatcher(String[] suffixes) {
            this.suffixes = (String[])suffixes.clone();
        }

        /* (overridden)
         * @see net.argius.frui.text.Pattern#find(java.lang.String)
         */
        public boolean find(String input) {
            int index = input.lastIndexOf('.');
            if (index >= 0) {
                String suffix = input.substring(index + 1);
                for (int i = 0; i < suffixes.length; i++) {
                    if (suffix.equalsIgnoreCase(suffixes[i])) {
                        return true;
                    }
                }
            }
            return false;
        }

        /* (overridden)
         * @see net.argius.frui.text.Pattern#matches(java.lang.String)
         */
        public boolean matches(String input) {
            return find(input);
        }

        /* (overridden)
         * @see net.argius.frui.text.Pattern#pattern()
         */
        public String pattern() {
            return Arrays.asList(suffixes).toString();
        }

        /* (overridden)
         * @see net.argius.frui.text.Pattern#replaceAll(java.lang.String, java.lang.String)
         */
        public String replaceAll(String input, String replacement) {
            return replaceFirst(input, replacement);
        }

        /* (overridden)
         * @see net.argius.frui.text.Pattern#replaceFirst(java.lang.String, java.lang.String)
         */
        public String replaceFirst(String input, String replacement) {
            int index = input.lastIndexOf('.');
            if (index >= 0) {
                String suffix = input.substring(index);
                for (int i = 0; i < suffixes.length; i++) {
                    if (suffix.equalsIgnoreCase(suffixes[i])) {
                        return input.substring(0, index) + replacement;
                    }
                }
            }
            return input;
        }

        /* (overridden)
         * @see net.argius.frui.text.Pattern#split(java.lang.String)
         */
        public String[] split(String input) {
            return new String[]{input};
        }

    }

}