package net.argius.frui.io;

/**
 * V[PXFIFOB
 * 
 * ̃IuWFNg͓ȂB
 */
class CharSequenceFIFO implements CharSequence {

    private static final int DEFAULT_CAPACITY = 16;

    private char[] buffer;
    private int limit;

    /**
     * CharSequenceFIFO̐B
     */
    public CharSequenceFIFO() {
        this(DEFAULT_CAPACITY);
    }

    /**
     * CharSequenceFIFO̐B
     * @param capacity eʃTCY
     */
    public CharSequenceFIFO(int capacity) {
        this.buffer = new char[capacity];
        this.limit = 0;
    }

    /* (overridden)
     * @see java.lang.CharSequence#charAt(int)
     */
    public char charAt(int index) {
        checkRange(index);
        return buffer[index];
    }

    /* (overridden)
     * @see java.lang.CharSequence#length()
     */
    public int length() {
        return limit;
    }

    /* (overridden)
     * @see java.lang.CharSequence#subSequence(int, int)
     */
    public CharSequence subSequence(int start, int end) {
        checkRange(end);
        return new String(buffer, start, end - start);
    }

    /**
     * ǉB
     * @param c 
     */
    public void add(char c) {
        ensure(1);
        buffer[limit++] = c;
    }

    /**
     * ǉB
     * @param array 
     */
    public void add(char[] array) {
        add(array, 0, array.length);
    }

    /**
     * ǉB
     * @param array 
     * @param offset ǎ̊Jnʒu
     * @param length ǎ̒
     */
    public void add(char[] array, int offset, int length) {
        ensure(length);
        System.arraycopy(array, offset, buffer, limit, length);
        limit += length;
    }

    /**
     * ǉB
     * @param string 
     */
    public void add(String string) {
        int length = string.length();
        ensure(length);
        string.getChars(0, length, buffer, limit);
        limit += length;
    }

    /**
     * w肵ʒuԂB
     * @param c 
     * @return ʒuBȂꍇ <code>-1</code>
     */
    public int indexOf(char c) {
        return indexOf(c, 0);
    }

    /**
     * w肵ʒuԂB
     * @param c 
     * @param fromIndex Jnʒu
     * @return ʒuBȂꍇ <code>-1</code>
     */
    public int indexOf(char c, int fromIndex) {
        if (fromIndex >= limit) {
            return -1;
        }
        int i = (fromIndex < 0) ? 0 : fromIndex;
        for (; i < limit; i++) {
            if (buffer[i] == c) {
                return i;
            }
        }
        return -1;
    }

    /**
     * w肵񂪌ʒuԂB
     * @param s 
     * @return 񂪌ʒuBȂꍇ <code>-1</code>
     */
    public int indexOf(String s) {
        return indexOf(s, 0);
    }

    /**
     * w肵񂪌ʒuԂB
     * @param s 
     * @param fromIndex Jnʒu
     * @return 񂪌ʒuBȂꍇ <code>-1</code>
     */
    public int indexOf(String s, int fromIndex) {
        return toString().indexOf(s, fromIndex);
    }

    /**
     * obt@𕥂oB
     * @return V[PX
     */
    public CharSequence draw() {
        return draw(limit);
    }

    /**
     * obt@𕥂oB
     * @param position oʒu
     * @return V[PX
     */
    public CharSequence draw(int position) {
        int length = Math.min(position, limit);
        String subString = new String(buffer, 0, length);
        int capacity = buffer.length;
        char[] newbuf = new char[capacity];
        System.arraycopy(buffer, position, newbuf, 0, capacity - position);
        buffer = newbuf;
        limit -= position;
        return subString;
    }

    /**
     * obt@\ȗeʂɊgB
     * @param size TCY
     */
    private void ensure(int size) {
        int length = buffer.length;
        if (length > limit + size) {
            return;
        }
        int newsize = length;
        while (newsize < length + size) {
            newsize <<= 1;
        }
        char[] newbuf = new char[newsize];
        System.arraycopy(buffer, 0, newbuf, 0, length);
        buffer = newbuf;
    }

    /**
     * ͈̓`FbNsB
     * @param index CfbNX
     */
    private void checkRange(int index) {
        if (index < 0 || index >= limit) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    /* (overridden)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (obj instanceof CharSequenceFIFO) {
            CharSequenceFIFO another = (CharSequenceFIFO)obj;
            if (another.limit == limit) {
                CharSequence cs1;
                CharSequence cs2;
                if (another.buffer.length > buffer.length) {
                    cs1 = new String(another.buffer, 0, limit);
                    cs2 = new String(buffer);
                } else if (another.buffer.length < buffer.length) {
                    cs1 = new String(another.buffer);
                    cs2 = new String(buffer, 0, limit);
                } else {
                    cs1 = new String(another.buffer);
                    cs2 = new String(buffer);
                }
                if (cs1.equals(cs2)) {
                    return true;
                }
            }
        }
        return false;
    }

    /* (overridden)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        int result = 17;
        result = 37 * result + String.valueOf(buffer).hashCode();
        result = 37 * result + limit;
        return result;
    }

    /* (overridden)
     * @see java.lang.CharSequence#toString()
     */
    public String toString() {
        return new String(buffer, 0, limit);
    }

}