package net.argius.frui.text;

import org.apache.regexp.*;

/**
 * p^[vNXB
 * <code>java.util.regex</code>pbP[Wւ̈ϏB
 */
final class PatternMatcher implements Pattern {

    private String expression;
    private String pattern;
    private int flags;

    /**
     * PatternMatcher̐B
     * @param expression ̃p^[\
     * @param pattern p^[
     * @param flags p^[tO
     */
    public PatternMatcher(String expression, String pattern, int flags) {
        this.expression = expression;
        this.pattern = pattern;
        this.flags = flags;
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#matches(java.lang.String)
     */
    public boolean matches(String input) {
        return REUtil.createRE("^" + pattern + "$", flags).match(input);
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#find(java.lang.String)
     */
    public boolean find(String input) {
        return REUtil.createRE(pattern, flags).match(input);
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#replaceAll(java.lang.String, java.lang.String)
     */
    public String replaceAll(String input, String replacement) {
        throw new UnsupportedOperationException("PatternMatcher.replaceAll");
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#replaceFirst(java.lang.String, java.lang.String)
     */
    public String replaceFirst(String input, String replacement) {
        throw new UnsupportedOperationException("PatternMatcher.replaceFirst");
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#split()
     */
    public String[] split(String input) {
        return REUtil.createRE(pattern, flags).split(input);
    }

    /* (overridden)
     * @see net.argius.frui.text.Pattern#pattern()
     */
    public String pattern() {
        return expression;
    }

}