/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.io;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.Messages;

public final class WasteBasket {
    private final String name;
    private final File directory;

    public WasteBasket(String string) {
        this(new File(string));
    }

    public WasteBasket(File file) {
        if (!file.exists()) {
            String string = Messages.getString("error.nonexistent.directory") + " : " + file;
            throw new IllegalOperationException(2, string);
        }
        Date date = new Date();
        String string = new SimpleDateFormat("yyyyMMdd").format(date);
        String string2 = new SimpleDateFormat("HHmmss").format(date);
        this.name = "waste:/" + string + '/' + string2;
        this.directory = new File(new File(file, string), string2);
    }

    public File getDirectory() {
        return this.directory;
    }

    public String toString() {
        return this.name;
    }
}

