package net.argius.frui.operation;

import java.io.*;
import java.util.*;

import net.argius.frui.*;
import net.argius.frui.io.*;
import net.argius.frui.text.*;

/**
 * ȕB
 */
public final class Replace extends Grep {

    private final String replaceString;
    private final File backupDirectory;
    private final boolean isIgnoreCase;

    /**
     * Replace̐B
     * @param patternString vp^[
     * @param replaceString up^[
     */
    public Replace(String patternString, String replaceString) {
        this(patternString, replaceString, false);
    }

    /**
     * Replace̐B
     * @param patternString vp^[
     * @param replaceString up^[
     * @param isIgnoreCase 啶𖳎ꍇ <code>true</code>
     */
    public Replace(String patternString,
                   String replaceString,
                   boolean isIgnoreCase) {
        super(patternString, isIgnoreCase);
        Utilities.checkModifiable();
        if (!Environment.getBooleanProperty("replace")) {
            throw new IllegalOperationException(IllegalOperationException.PROPERTY,
                                                Messages.getString("error.unable.modify"));
        }
        this.replaceString = replaceString;
        this.backupDirectory = Utilities.createTemporaryDirectory();
        this.isIgnoreCase = isIgnoreCase;
    }

    /* (overridden)
     * @see net.argius.frui.operation.Operation#operate(net.argius.frui.operation.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        super.operate(fileInfo);
        List lineInfoList = fileInfo.getLineInfoList();
        if (!lineInfoList.isEmpty()) {
            replace(fileInfo);
        }
        return isNegative != (!lineInfoList.isEmpty());
    }

    /**
     * usB
     * @param fileInfo t@C
     * @throws IOException o̓G[ꍇ
     */
    private void replace(FileInfo fileInfo) throws IOException {
        File src = fileInfo.getFile();
        backupFile(src);
        File tmp = File.createTempFile(Constants.TEMPORARY_PREFIX,
                                       Constants.TEMPORARY_SUFFIX);
        tmp.deleteOnExit();
        if (detectEncoding && fileInfo.getEncodingType().isDetected()) {
            String encName = fileInfo.getEncodingType().getName();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmp),
                                                                              encName));
            try {
                LineReader reader = new LineReader(new InputStreamReader(new FileInputStream(src),
                                                                         encName));
                try {
                    replaceLines(fileInfo, reader, writer);
                } finally {
                    reader.close();
                }
            } finally {
                writer.close();
            }
        } else {
            BufferedWriter writer = new BufferedWriter(new FileWriter(tmp));
            try {
                LineReader reader = new LineReader(new FileReader(src));
                try {
                    replaceLines(fileInfo, reader, writer);
                } finally {
                    reader.close();
                }
            } finally {
                writer.close();
            }
        }
        IOUtilities.copy(tmp, src, true);
    }

    /**
     * t@CobNAbvB
     * @param src t@C
     * @throws IOException o̓G[ꍇ
     */
    private void backupFile(File src) throws IOException {
        if (!backupDirectory.exists()) {
            backupDirectory.mkdirs();
        }
        File backup = new File(backupDirectory, src.getPath());
        try {
            IOUtilities.copy(src, backup.getCanonicalFile());
        } catch (IOException ex) {
            IOException exception = new IOException("backup error ("
                                                    + backup
                                                    + ')');
            exception.initCause(ex);
            throw exception;
        }
    }

    /**
     * susB
     * @param fileInfo t@C
     * @param reader LineReader
     * @param writer BufferedWriter
     * @throws IOException o̓G[ꍇ
     */
    private void replaceLines(FileInfo fileInfo,
                              LineReader reader,
                              BufferedWriter writer) throws IOException {
        List list = fileInfo.getLineInfoList();
        int targetNumber = 0;
        for (int i = 0, n = list.size();;) {
            String line = reader.readLine();
            if (line == null) {
                break;
            }
            int lineNumber = reader.getLineNumber();
            if (targetNumber < lineNumber && i < n) {
                LineInfo info = (LineInfo)list.get(i);
                targetNumber = info.getLineNumber();
            }
            if (targetNumber == lineNumber) {
                line = Utilities.replaceAll(pattern, line, replaceString);
                list.set(i++, new LineInfo(lineNumber, line));
            }
            writer.write(line);
            writer.write(reader.getLineSeparator());
        }
    }

    /* (overridden)
     * @see net.argius.frui.operation.Condition#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (isIgnoreCase) {
            buffer.append('i');
        }
        buffer.append(Utilities.getSimpleClassName(Replace.class));
        buffer.append('(');
        String s = pattern.pattern();
        if (s.startsWith("/")) {
            Pattern p = PatternFactory.create("/\\/(.*)\\/(i?)/");
            String r = "s/$1/" + replaceString + "/$2";
            buffer.append(p.replaceFirst(s, r));
        } else {
            buffer.append(s);
            buffer.append(',');
            buffer.append(replaceString);
        }
        buffer.append(')');
        return buffer.toString();
    }

}