package net.argius.frui.operation;

import java.io.*;

import net.argius.frui.*;

/**
 * o͌`̊B
 * o͂Ɏgpp[^⑀LB
 */
public abstract class Print implements Operation {

    private final boolean useTrimPath;
    private final boolean useReplaceSeparator;
    private final char plainSeparator;
    private final char newSeparator;

    /**
     * Print̐B
     */
    public Print() {
        // pXtrim
        useTrimPath = Environment.getBooleanProperty("path.trim");
        // pXZp[^
        plainSeparator = File.separatorChar;
        String replaceSeparator = Environment.getProperty("path.separator");
        if (replaceSeparator.length() == 1
            && !replaceSeparator.equals(File.separator)) {
            newSeparator = replaceSeparator.charAt(0);
            useReplaceSeparator = true;
        } else {
            newSeparator = plainSeparator;
            useReplaceSeparator = false;
        }
    }

    /**
     * bZ[Wo͂B
     * @param message bZ[W
     */
    public void printMessage(String message) {
        System.err.println(message);
    }

    /**
     * G[o͂B
     * @param message bZ[W
     * @param th O
     */
    public void printError(String message, Throwable th) {
        System.err.println(message);
        if (Environment.getBooleanProperty("debug")) {
            th.printStackTrace();
        }
    }

    /**
     * intlB
     * i10El߁j
     * @param intValue intl
     * @return ꂽintl
     */
    protected final String padInt(int intValue) {
        final String space10 = "          ";
        String intString = String.valueOf(intValue);
        return space10.substring(intString.length()) + intString;
    }

    /**
     * longlB
     * i19El߁j
     * @param longValue longl
     * @return ꂽlongl
     */
    protected final String padLong(long longValue) {
        final String space19 = "                   ";
        String longString = String.valueOf(longValue);
        return space19.substring(longString.length()) + longString;
    }

    /**
     * IuWFNgo͂B
     * @param object IuWFNg
     */
    protected void print(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            char[] buffer = file.getPath().toCharArray();
            int length = buffer.length;
            int offset = 0;
            if (useTrimPath && !file.isAbsolute() && length >= 2) {
                if (buffer[0] == '.' && buffer[1] == plainSeparator) {
                    offset = 2;
                    length -= 2;
                }
            }
            if (useReplaceSeparator) {
                for (int i = offset; i < length; i++) {
                    if (buffer[i] == plainSeparator) {
                        buffer[i] = newSeparator;
                    }
                }
            }
            System.out.print(new String(buffer, offset, length));
        } else {
            System.out.print(object);
        }
    }

    /**
     * sB
     */
    protected void println() {
        System.out.println();
    }

    /**
     * IuWFNgo͂ĉsB
     * @param object IuWFNg
     */
    protected void println(Object object) {
        print(object);
        System.out.println();
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return Utilities.getSimpleClassName(getClass());
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        printInfo(fileInfo);
        return false;
    }

    /**
     * t@Co͂B
     * @param fileInfo t@C
     * @throws IOException o̓G[ꍇ
     */
    protected abstract void printInfo(FileInfo fileInfo) throws IOException;

}