package net.argius;

import java.io.*;
import java.util.*;

import net.argius.frui.*;
import net.argius.frui.operation.*;

/**
 * FruiAPIƂĈ߂̑񋟂B
 */
public final class FruiRunner {

    private final Application application;
    private final Operation[] operations;
    private final File[] roots;

    /**
     * FruiRunner̐B
     * @param operations ̔z
     */
    public FruiRunner(Operation[] operations) {
        this(Arrays.asList(operations), new File[0]);
    }

    /**
     * FruiRunner̐B
     * @param operations ̔z
     * @param root JnfBNg
     */
    public FruiRunner(Operation[] operations, File root) {
        this(Arrays.asList(operations), new File[]{root});
    }

    /**
     * FruiRunner̐B
     * @param operations ̔z
     * @param roots JnfBNg
     */
    public FruiRunner(Operation[] operations, File[] roots) {
        this(Arrays.asList(operations), roots);
    }

    /**
     * FruiRunner̐B
     * @param operationList ̃Xg
     */
    public FruiRunner(List operationList) {
        this(operationList, new File[0]);
    }

    /**
     * FruiRunner̐B
     * @param operationList ̃Xg
     * @param root JnfBNg
     */
    public FruiRunner(List operationList, File root) {
        this(operationList, new File[]{root});
    }

    /**
     * FruiRunner̐B
     * @param operationList ̃Xg
     * @param roots JnfBNg
     */
    public FruiRunner(List operationList, File[] roots) {
        this.application = new Application();
        this.operations = (Operation[])operationList.toArray(new Operation[operationList.size()]);
        this.roots = (File[])roots.clone();
    }

    /**
     * FruiRunner̐B
     * @param operations ̔z
     * @param application AvP[V
     */
    private FruiRunner(Operation[] operations, Application application) {
        this.application = application;
        this.operations = operations;
        this.roots = application.getDirectories();
    }

    /**
     * IvV͂B
     * @param optionString IvV
     * @return FruiRunnerCX^X
     */
    public static FruiRunner parseOption(String optionString) {
        Application app = new Application();
        Operation[] operations = Frui.parseOption(optionString, app);
        return new FruiRunner(operations, app);
    }

    /**
     * IvV͂B
     * @param optionStrings IvV̔z
     * @return FruiRunnerCX^X
     */
    public static FruiRunner parseOption(String[] optionStrings) {
        Application app = new Application();
        Operation[] operations = Frui.parseOption(optionStrings, app);
        return new FruiRunner(operations, app);
    }

    /**
     * ő[x̐ݒB
     * @param maxDepth ő[x
     */
    public void setMaxDepth(int maxDepth) {
        application.setMaxDepth(maxDepth);
    }

    /**
     * ŏ[x̐ݒB
     * @param minDepth ŏ[x
     */
    public void setMinDepth(int minDepth) {
        application.setMinDepth(minDepth);
    }

    /**
     * ̐ݒB
     * @param limit 
     */
    public void setLimit(int limit) {
        application.setLimit(limit);
    }

    /**
     * t@Čʂ擾B
     * @return t@CpX̔z
     */
    public String[] getPaths() {
        return getPaths(application, operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @return t@C̔z
     */
    public File[] getFiles() {
        return getFiles(application, operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @return t@C̔z
     */
    public FileInfo[] getFileInfos() {
        return getFileInfos(application, operations, roots);
    }

    /**
     * t@CJnB
     */
    public void start() {
        start(application, operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @return t@CpX̔z
     */
    public static String[] getPaths(List operationList) {
        return getPaths(operationList, new File[0]);
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @param root JnfBNg
     * @return t@CpX̔z
     */
    public static String[] getPaths(List operationList, File root) {
        return getPaths(operationList, new File[]{root});
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @param roots JnfBNg̔z
     * @return t@CpX̔z
     */
    public static String[] getPaths(List operationList, File[] roots) {
        Operation[] operations = (Operation[])operationList.toArray(new Operation[operationList.size()]);
        return getPaths(operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @return t@CpX̔z
     */
    public static String[] getPaths(Operation[] operations) {
        return getPaths(operations, new File[0]);
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @param root JnfBNg
     * @return t@CpX̔z
     */
    public static String[] getPaths(Operation[] operations, File root) {
        return getPaths(operations, new File[]{root});
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @param roots JnfBNg̔z
     * @return t@CpX̔z
     */
    public static String[] getPaths(Operation[] operations, File[] roots) {
        return getPaths(new Application(), operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @param application Application
     * @param operations ̔z
     * @param roots JnfBNg̔z
     * @return t@CpX̔z
     */
    private static String[] getPaths(Application application, Operation[] operations, File[] roots) {
        FileInfo[] infos = getFileInfos(application, operations, roots);
        String[] paths = new String[infos.length];
        for (int i = 0; i < paths.length; i++) {
            paths[i] = infos[i].getFile().getPath();
        }
        return paths;
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @return t@C̔z
     */
    public static File[] getFiles(List operationList) {
        return getFiles(operationList, new File[0]);
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @param root JnfBNg
     * @return t@C̔z
     */
    public static File[] getFiles(List operationList, File root) {
        return getFiles(operationList, new File[]{root});
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @param roots JnfBNg̔z
     * @return t@C̔z
     */
    public static File[] getFiles(List operationList, File[] roots) {
        Operation[] operations = (Operation[])operationList.toArray(new Operation[operationList.size()]);
        return getFiles(operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @return t@C̔z
     */
    public static File[] getFiles(Operation[] operations) {
        return getFiles(operations, new File[0]);
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @param root JnfBNg
     * @return t@C̔z
     */
    public static File[] getFiles(Operation[] operations, File root) {
        return getFiles(operations, new File[]{root});
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @param roots JnfBNg̔z
     * @return t@C̔z
     */
    public static File[] getFiles(Operation[] operations, File[] roots) {
        return getFiles(new Application(), operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @param application Application
     * @param operations ̔z
     * @param roots JnfBNg̔z
     * @return t@C̔z
     */
    private static File[] getFiles(Application application, Operation[] operations, File[] roots) {
        FileInfo[] infos = getFileInfos(application, operations, roots);
        File[] files = new File[infos.length];
        for (int i = 0; i < files.length; i++) {
            files[i] = infos[i].getFile();
        }
        return files;
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @return t@C̔z
     */
    public static FileInfo[] getFileInfos(List operationList) {
        return getFileInfos(operationList, new File[0]);
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @param root JnfBNg
     * @return t@C̔z
     */
    public static FileInfo[] getFileInfos(List operationList, File root) {
        return getFileInfos(operationList, new File[]{root});
    }

    /**
     * t@Čʂ擾B
     * @param operationList ̃Xg
     * @param roots JnfBNg̔z
     * @return t@C̔z
     */
    public static FileInfo[] getFileInfos(List operationList, File[] roots) {
        Operation[] operations = (Operation[])operationList.toArray(new Operation[operationList.size()]);
        return getFileInfos(operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @return t@C̔z
     */
    public static FileInfo[] getFileInfos(Operation[] operations) {
        return getFileInfos(operations, new File[0]);
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @param root JnfBNg
     * @return t@C̔z
     */
    public static FileInfo[] getFileInfos(Operation[] operations, File root) {
        return getFileInfos(operations, new File[]{root});
    }

    /**
     * t@Čʂ擾B
     * @param operations ̔z
     * @param roots JnfBNg̔z
     * @return t@C̔z
     */
    public static FileInfo[] getFileInfos(Operation[] operations, File[] roots) {
        return getFileInfos(new Application(), operations, roots);
    }

    /**
     * t@Čʂ擾B
     * @param application Application
     * @param operations Operation̔z
     * @param roots JnfBNg̔z
     * @return t@C̔z
     */
    private static FileInfo[] getFileInfos(Application application,
                                           Operation[] operations,
                                           File[] roots) {
        Collector collector = new Collector();
        application.setDirectories(roots);
        application.invoke(operations, collector);
        return collector.getFileInfos();
    }

    /**
     * t@CJnB
     * @param operationList ̃Xg
     */
    public static void start(List operationList) {
        start(operationList, new File[0]);
    }

    /**
     * t@CJnB
     * @param operationList ̃Xg
     * @param root JnfBNg
     */
    public static void start(List operationList, File root) {
        start(operationList, new File[]{root});
    }

    /**
     * t@CJnB
     * @param operationList ̃Xg
     * @param roots JnfBNg̔z
     */
    public static void start(List operationList, File[] roots) {
        Operation[] operations = (Operation[])operationList.toArray(new Operation[operationList.size()]);
        start(operations, roots);
    }

    /**
     * t@CJnB
     * @param operations ̔z
     */
    public static void start(Operation[] operations) {
        start(operations, new File[0]);
    }

    /**
     * t@CJnB
     * @param operations ̔z
     * @param root JnfBNg
     */
    public static void start(Operation[] operations, File root) {
        start(operations, new File[]{root});
    }

    /**
     * t@CJnB
     * @param operations ̔z
     * @param roots JnfBNg̔z
     */
    public static void start(Operation[] operations, File[] roots) {
        start(new Application(), operations, roots);
    }

    /**
     * t@CJnB
     * @param application AvP[VIuWFNg
     * @param operations ̔z
     * @param roots JnfBNg̔z
     */
    private static void start(Application application, Operation[] operations, File[] roots) {
        application.setDirectories(roots);
        application.invoke(operations);
    }

}