package net.argius;

import java.io.*;
import java.util.*;

import net.argius.frui.*;
import net.argius.frui.operation.*;

/**
 * FruiCNXB
 * {IɃR}hC̋Nz肵ĂB
 */
public final class Frui {

    private static final int STATUS_OK = 0;
    private static final int STATUS_ILLEGAL_OPERATION = 1;
    private static final int STATUS_UNEXPECTED = -1;

    private static final String KEYWORD_SHOTAGE = "shotage";
    private static final String RANGE_OP = "..";

    /**
     * Frui̐B
     */
    private Frui() {
        // empty
    }

    /**
     * ǉB
     * @param operationList Xg
     * @param condition 
     * @param isNegative NOTw肳Ăꍇ <code>true</code>
     */
    private static void addCondition(List operationList, Condition condition, boolean isNegative) {
        condition.setNegative(isNegative);
        operationList.add(condition);
    }

    /**
     * [ݒ肷B
     * JgfBNg <code>1</code> Ƃ[𐮐Ŏw肷B
     * ł邱ƈȊÕ`FbN͍sȂB
     * [̕\͈ȉ̒ʂB
     * <dl>
     *   <dt><code>a..b</code></dt><dd>a[b󂢃fBNĝݏ</dd>
     *   <dt><code>a.. </code></dt><dd>a[fBNĝݏ</dd>
     *   <dt><code>..a </code></dt><dd>a󂢃fBNĝݏ</dd>
     *   <dt><code>a   </code></dt><dd><code>..a</code>Ɠ</dd>
     * </dl>
     * @param application Application
     * @param expression [̕\
     */
    private static void setDepth(Application application, String expression) {
        int index = expression.indexOf(RANGE_OP);
        try {
            if (index >= 0) {
                if (index == 0) { // startsWith
                    String to = expression.substring(RANGE_OP.length());
                    application.setMaxDepth(Integer.parseInt(to));
                } else if (expression.endsWith(RANGE_OP)) {
                    String from = expression.substring(0, expression.length() - RANGE_OP.length());
                    application.setMinDepth(Integer.parseInt(from));
                } else {
                    String from = expression.substring(0, index);
                    String to = expression.substring(index + RANGE_OP.length());
                    application.setMinDepth(Integer.parseInt(from));
                    application.setMaxDepth(Integer.parseInt(to));
                }
            } else {
                application.setMaxDepth(Integer.parseInt(expression));
            }
        } catch (RuntimeException ex) {
            throw new IllegalOperationException(IllegalOperationException.EXPRESSION,
                                                expression,
                                                ex);
        }
    }

    /**
     * O𓊂B
     * @param operationName 
     * @param message bZ[W
     */
    private static void throwException(String operationName, String message) {
        throw new IllegalArgumentException(message + Constants.MESSAGE_SEPARATOR + operationName);
    }

    /**
     * bZ[W擾B
     * @param keyword bZ[W̃L[[h
     * @return bZ[W
     */
    private static String getMessage(String keyword) {
        return Messages.getString(keyword);
    }

    /**
     * G[bZ[W擾B
     * @param keyword G[bZ[W̃L[[h
     * @return G[bZ[W
     */
    private static String getErrorMessage(String keyword) {
        return getMessage("usage.error." + keyword);
    }

    /**
     * sB
     * @param args R}hC
     * @return IXe[^X
     */
    private static int execute(String[] args) {
        if (args.length == 0) {
            Notice.printUsage();
            return STATUS_OK;
        }
        String argument = args[0];
        /*
         * 
         */
        // version
        if (argument.equals("-v") || argument.equals("--version")) {
            Notice.printVersion(false);
            return STATUS_OK;
        }
        if (argument.equals("-V") || argument.equals("--VERSION")) {
            Notice.printVersion(true);
            return STATUS_OK;
        }
        // help
        if (argument.equals("-h") || argument.equals("--help")) {
            Notice.printUsage();
            return STATUS_OK;
        }
        Application application = new Application();
        Operation[] operations = parseOption(args, application);
        if (application.isVerbose()) {
            VerboseMode.invoke(application, operations);
        } else {
            application.invoke(operations);
        }
        return STATUS_OK;
    }

    /**
     * IvV͂B
     * @param optionString IvV
     * @return Operation̔z
     */
    public static Operation[] parseOption(String optionString) {
        return parseOption(optionString, new Application());
    }

    /**
     * IvV͂B
     * @param optionStrings IvV̔z
     * @return Operation̔z
     */
    public static Operation[] parseOption(String[] optionStrings) {
        return parseOption(optionStrings, new Application());
    }

    /**
     * IvV͂B
     * @param optionString IvV
     * @param application AvP[V
     * @return Operation̔z
     */
    public static Operation[] parseOption(String optionString, Application application) {
        return parseOption(optionString.split(" "), application);
    }

    /**
     * IvV͂B
     * @param optionStrings IvV
     * @param application AvP[V
     * @return Operation̔z
     */
    public static Operation[] parseOption(String[] optionStrings, Application application) {
        String[] args = optionStrings; // alias
        List operationList = new ArrayList();
        List operationListReference = operationList;
        boolean selectedReplace = false;
        boolean selectedZip = false;
        for (int i = 0, n = args.length; i < n; i++) {
            String argument = args[i];
            /*
             * 
             */
            // directory
            if (argument.equals("-d") || argument.equals("--directory")) {
                if (++i >= n) {
                    throwException("directory", getErrorMessage(KEYWORD_SHOTAGE));
                }
                File directory = new File(args[i]);
                if (!directory.isDirectory()) {
                    throwException(args[i], getErrorMessage("notdirectory"));
                }
                application.addDirectory(directory);
                continue;
            }
            // depth
            if (argument.equals("--depth")) {
                if (++i >= n) {
                    throwException("depth", getErrorMessage(KEYWORD_SHOTAGE));
                }
                setDepth(application, args[i]);
                continue;
            }
            // stdin
            if (argument.equals("-i") || argument.equals("--stdin")) {
                application.setPiped(true);
                continue;
            }
            // upper
            if (argument.equals("-u") || argument.equals("--upper")) {
                if (++i >= n) {
                    throwException("upper", getErrorMessage(KEYWORD_SHOTAGE));
                }
                application.setLimit(Integer.parseInt(args[i]));
                continue;
            }
            // verbose
            if (argument.equals("--verbose")) {
                application.setVerbose(true);
                continue;
            }
            /*
             * 
             */
            // NOT1
            boolean isNegative = false;
            if (argument.equals("!") || argument.equals("--not")) {
                if (++i >= n) {
                    throw new IllegalArgumentException(getErrorMessage("not.illegalposition"));
                }
                argument = args[i];
                isNegative = true;
            }
            // AND
            if (argument.equals("-a") || argument.equals("--and")) {
                if (operationList != operationListReference) {
                    operationList = operationListReference;
                }
                continue;
            }
            // OR1
            if (argument.equals("-o") || argument.equals("--or")) {
                if (++i >= n) {
                    throw new IllegalArgumentException(getErrorMessage("or.illegalposition"));
                }
                operationList = new OrOperation(isNegative);
                operationListReference.add(operationList);
                argument = args[i];
                isNegative = false;
            }
            // default (find)
            if (!argument.startsWith("-")) {
                addCondition(operationList, new Find(argument), isNegative);
                continue;
            }
            // ignore-case
            boolean isIgnoreCase = false;
            if (argument.length() == 3 && argument.charAt(2) == 'i') { // && argument.startsWith("-")
                char c = argument.charAt(1);
                if (c == 'c'
                    || c == 'f'
                    || c == 'g'
                    || c == 'm'
                    || c == 'n'
                    || c == 'r'
                    || c == 'z') {
                    argument = argument.substring(0, 2);
                    isIgnoreCase = true;
                }
            }
            // binary
            if (argument.equals("-B") || argument.equals("--binary")) {
                addCondition(operationList, new Binary(), isNegative);
                continue;
            }
            // clear matched lines
            if (argument.equals("-C") || argument.equals("--clear")) {
                addCondition(operationList, new Clear(), isNegative);
                continue;
            }
            // find
            if (argument.equals("-f") || argument.equals("--find")) {
                if (++i >= n) {
                    throwException("find", getErrorMessage(KEYWORD_SHOTAGE));
                }
                Condition condition = new Find(args[i], isIgnoreCase);
                addCondition(operationList, condition, isNegative);
                continue;
            }
            // grep
            if (argument.equals("-g") || argument.equals("--grep")) {
                if (++i >= n) {
                    throwException("grep", getErrorMessage(KEYWORD_SHOTAGE));
                }
                Condition condition = new Grep(args[i], isIgnoreCase);
                addCondition(operationList, condition, isNegative);
                continue;
            }
            // name
            if (argument.equals("-n") || argument.equals("--name")) {
                if (++i >= n) {
                    throwException("name", getErrorMessage(KEYWORD_SHOTAGE));
                }
                Condition condition = new Name(args[i], isIgnoreCase);
                addCondition(operationList, condition, isNegative);
                continue;
            }
            // replace
            if (argument.equals("-r") || argument.equals("--replace")) {
                String arg1 = args[++i];
                if (++i >= n) {
                    throwException("replace", getErrorMessage(KEYWORD_SHOTAGE));
                }
                Condition condition = new Replace(arg1, args[i], isIgnoreCase);
                operationList.add(condition);
                selectedReplace = true;
                continue;
            }
            // size
            if (argument.equals("-s") || argument.equals("--size")) {
                if (++i >= n) {
                    throwException("size", getErrorMessage(KEYWORD_SHOTAGE));
                }
                addCondition(operationList, Size.getInstance(args[i]), isNegative);
                continue;
            }
            // time
            if (argument.equals("-t") || argument.equals("--time")) {
                if (++i >= n) {
                    throwException("time", getErrorMessage(KEYWORD_SHOTAGE));
                }
                addCondition(operationList, new Time(args[i]), isNegative);
                continue;
            }
            // text
            if (argument.equals("-T") || argument.equals("--text")) {
                addCondition(operationList, new Binary(), !isNegative);
                continue;
            }
            // examine
            if (argument.equals("-x") || argument.equals("--examine")) {
                if (++i >= n) {
                    throwException("examine", getErrorMessage(KEYWORD_SHOTAGE));
                }
                addCondition(operationList, Examine.getInstance(args[i]), isNegative);
                continue;
            }
            // zip
            if (argument.equals("-z") || argument.equals("--zip")) {
                if (++i >= n) {
                    throwException("zip", getErrorMessage(KEYWORD_SHOTAGE));
                }
                Condition condition = new GrepZip(args[i], isIgnoreCase);
                addCondition(operationList, condition, isNegative);
                selectedZip = true;
                continue;
            }
            // NOT2
            if (isNegative) {
                throw new IllegalArgumentException(getErrorMessage("not.isonlyfilter"));
            }
            /*
             * o͏
             */
            // html
            if (argument.equals("--html")) {
                operationList.add(new PrintHTML(args));
                continue;
            }
            // list
            if (argument.equals("-l") || argument.equals("--list")) {
                operationList.add(new PrintList());
                continue;
            }
            // number
            if (argument.equals("-N") || argument.equals("--number")) {
                operationList.add(new PrintLinesNumber());
                continue;
            }
            // path
            if (argument.equals("-p") || argument.equals("--path")) {
                operationList.add(new PrintPath());
                continue;
            }
            // quiet
            if (argument.equals("-q") || argument.equals("--quiet")) {
                operationList.add(new PrintQuiet());
                continue;
            }
            // suffix
            if (argument.equals("--suffix")) {
                operationList.add(new PrintSuffixSet());
                continue;
            }
            // fullpath
            if (argument.equals("--fullpath")) {
                operationList.add(new PrintFullPath());
                continue;
            }
            /*
             * ړ
             */
            // copy
            if (argument.equals("-c") || argument.equals("--copy")) {
                String arg1 = args[++i];
                if (++i >= n) {
                    throwException("copy", getErrorMessage(KEYWORD_SHOTAGE));
                }
                operationList.add(new Copy(arg1, args[i], isIgnoreCase));
                continue;
            }
            // move
            if (argument.equals("-m") || argument.equals("--move")) {
                String arg1 = args[++i];
                if (++i >= n) {
                    throwException("move", getErrorMessage(KEYWORD_SHOTAGE));
                }
                operationList.add(new Move(arg1, args[i], isIgnoreCase));
                continue;
            }
            // waste
            if (argument.equals("-w") || argument.equals("--waste")) {
                operationList.add(new Waste());
                continue;
            }
            /*
             * ̑
             */
            // evaluate
            if (argument.equals("-e") || argument.equals("--evaluate")) {
                try {
                    String name = args[++i];
                    String[] arguments = new String[0];
                    if (name.length() == 1) {
                        char initial = name.charAt(0);
                        if (Character.isDigit(initial)) {
                            int size = Character.digit(initial, 10);
                            name = args[++i];
                            arguments = new String[size];
                            for (int j = 0; j < size; j++) {
                                arguments[j] = args[++i];
                            }
                        }
                    }
                    operationList.add(new Evaluate(name, arguments));
                } catch (RuntimeException ex) {
                    if (i >= args.length) {
                        throwException("eval", getErrorMessage(KEYWORD_SHOTAGE));
                    }
                    throw ex;
                }
                continue;
            }
            // illegal option
            if (argument.equals("-v")
                || argument.equals("--version")
                || argument.equals("-V")
                || argument.equals("--VERSION")
                || argument.equals("-h")
                || argument.equals("--help")) {
                throwException(argument, getErrorMessage("illegalposition"));
            }
            throwException(argument, getErrorMessage("illegaloption"));
        }
        operationList = operationListReference;
        if (operationList.isEmpty()) {
            throw new IllegalArgumentException(getErrorMessage("hasnocondition"));
        }
        if (selectedReplace && selectedZip) {
            throw new IllegalArgumentException(getErrorMessage("cannotuse.replacezip"));
        }
        Ignore ignore = new Ignore();
        if (ignore.isEnabled()) {
            operationList.add(0, ignore);
        }
        return (Operation[])operationListReference.toArray(new Operation[operationListReference.size()]);
    }

    /**
     * sȑɂG[̏B
     * @param ex G[
     */
    private static void handleOperationError(IllegalOperationException ex) {
        if (Environment.getBooleanProperty("debug")) {
            ex.printStackTrace();
            System.err.println();
        }
        String message;
        switch (ex.getType()) {
            case IllegalOperationException.PROPERTY:
                message = Messages.getString("error.type.property");
                break;
            case IllegalOperationException.EXPRESSION:
                message = Messages.getString("error.type.expression");
                break;
            case IllegalOperationException.IO:
                message = Messages.getString("error.type.io");
                break;
            case IllegalOperationException.RUNTIME:
                message = Messages.getString("error.type.runtime");
                break;
            default:
                message = Messages.getString("error.type.unknown");
        }
        System.err.println(message + Constants.MESSAGE_SEPARATOR + ex.getMessage());
        System.err.println(Messages.getString("error.see.manual"));
    }

    /**
     * vIG[̏B
     * @param th G[
     */
    private static void handleFatalError(Throwable th) {
        if (Environment.getBooleanProperty("debug")) {
            th.printStackTrace();
            System.err.println();
        }
        System.err.print(Messages.getString("error.fatal"));
        String message = th.getMessage();
        if (message != null) {
            System.err.print(' ');
            System.err.print(message);
        }
        System.err.println();
    }

    /**
     * AvP[VNB
     * @param args wvQ
     */
    public static void main(String[] args) {
        int status;
        try {
            status = execute(args);
        } catch (IllegalOperationException ex) {
            // IvV\z̃G[
            handleOperationError(ex);
            status = STATUS_ILLEGAL_OPERATION;
        } catch (RuntimeException ex) {
            // \ȂsG[
            handleOperationError(new IllegalOperationException(IllegalOperationException.RUNTIME,
                                                               ex.getMessage(),
                                                               ex));
            status = STATUS_ILLEGAL_OPERATION;
        } catch (Error error) {
            // JavaG[
            handleFatalError(error);
            status = STATUS_UNEXPECTED;
        }
        if (status != STATUS_OK) {
            System.exit(status);
        }
    }

}