/**
 * 
 */
package net.argius.frui.operation;

import java.io.*;
import java.util.*;

import net.argius.frui.*;
import net.argius.frui.text.*;

/**
 * GrepORB
 */
public final class OrGrep extends Condition {

    /*
     * GREP̃XgێĂB
     * OrGrep󂯎FileInfoGREPɃRs[ēnB
     * ̌ʂj[N\[gČFileInfoɐݒ肷B
     * 
     * Set⃆j[N\[g邽߂ɂ́A
     * equalsI[oChComparableKvA
     * LineInfoɂ͎ĂȂ߁A
     * ̃NXœƎ`ĂB
     */

    // t
    private static final Comparator comparator = new Comparator() {

        public int compare(Object o1, Object o2) {
            LineInfo info1 = (LineInfo)o1;
            LineInfo info2 = (LineInfo)o2;
            return info1.getLineNumber() - info2.getLineNumber();
        }

    };

    private final Grep[] greps;

    /**
     * OrGrep̐B
     * @param patternString
     */
    public OrGrep(String patternString) {
        this(patternString, false);
    }

    /**
     * OrGrep̐B
     * @param patternString
     * @param isIgnoreCase
     */
    public OrGrep(String patternString, boolean isIgnoreCase) {
        super(patternString, isIgnoreCase);
        List list = new ArrayList();
        StringMatcher m = new StringMatcher(",");
        String[] patterns = m.split(patternString);
        for (int i = 0; i < patterns.length; i++) {
            String pattern = patterns[i];
            list.add(new Grep(pattern, isIgnoreCase));
        }
        this.greps = (Grep[])list.toArray(new Grep[list.size()]);
    }

    /* (overridden)
     * @see net.argius.frui.Operation#operate(net.argius.frui.FileInfo)
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        Map map = new HashMap();
        for (int i = 0; i < greps.length; i++) {
            FileInfo copy = getCopy(fileInfo);
            greps[i].operate(copy);
            Iterator it = copy.getLineInfoList().iterator();
            // sԍňӂɂ
            while (it.hasNext()) {
                LineInfo info = (LineInfo)it.next();
                map.put(new Integer(info.getLineNumber()), info);
            }
        }
        List lineInfo = fileInfo.getLineInfoList();
        lineInfo.clear();
        lineInfo.addAll(map.values());
        Collections.sort(lineInfo, comparator);
        return isNegative == lineInfo.isEmpty();
    }

    /**
     * Rs[̐B
     * @param fileInfo Rs[
     * @return Rs[ꂽt@C
     */
    private static FileInfo getCopy(FileInfo fileInfo) {
        FileInfo info = new FileInfo();
        info.setFile(fileInfo.getFile());
        info.getLineInfoList().addAll(fileInfo.getLineInfoList());
        info.setEncodingType(fileInfo.getEncodingType());
        return info;
    }

    /* (overridden)
     * @see net.argius.frui.operation.Condition#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("OrGrep(");
        Iterator it = Arrays.asList(greps).iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            buffer.append(it.next());
            hasNext = it.hasNext();
            if (hasNext) {
                buffer.append('+');
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

}
