/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.IOException;
import net.argius.frui.FileInfo;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.io.FileSize;
import net.argius.frui.operation.Condition;

public abstract class Size
extends Condition {
    private final long value;

    protected Size(long l) {
        this(l, "");
    }

    protected Size(long l, String string) {
        super(Size.editSizeExpression(l, string), false);
        this.value = l;
    }

    private static String editSizeExpression(long l, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Character.isDigit(string.charAt(0)) ? 0 : 1;
        stringBuffer.append(string.substring(n));
        if (!String.valueOf(l).equals(string)) {
            stringBuffer.append('=').append(l);
        }
        stringBuffer.append("bytes");
        return stringBuffer.toString();
    }

    public boolean operate(FileInfo fileInfo) throws IOException {
        File file = fileInfo.getFile();
        if (file.isDirectory()) {
            return false;
        }
        return this.isNegative != this.compare(this.value, file.length());
    }

    protected abstract boolean compare(long var1, long var3);

    public static Size getInstance(String string) {
        return Size.parseExpression(string);
    }

    private static Size parseExpression(String string) {
        int n = 0;
        char c = string.charAt(0);
        if (!Character.isDigit(c)) {
            ++n;
        }
        long l = FileSize.toLong(string.substring(n));
        if (c == '+') {
            return new MinLimit(l, string);
        }
        if (c == '-') {
            return new MaxLimit(l, string);
        }
        if (c == '=' || Character.isDigit(c)) {
            return new Equal(l, string);
        }
        throw new IllegalOperationException(1, string);
    }

    public static final class MinLimit
    extends Size {
        public MinLimit(long l, String string) {
            super(l, string);
        }

        protected boolean compare(long l, long l2) {
            return l2 >= l;
        }
    }

    public static final class MaxLimit
    extends Size {
        public MaxLimit(long l, String string) {
            super(l, string);
        }

        protected boolean compare(long l, long l2) {
            return l2 <= l;
        }
    }

    public static final class Equal
    extends Size {
        public Equal(long l, String string) {
            super(l, string);
        }

        protected boolean compare(long l, long l2) {
            return l2 == l;
        }
    }
}

