/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import net.argius.frui.Environment;
import net.argius.frui.FileInfo;
import net.argius.frui.LineInfo;
import net.argius.frui.io.IOUtilities;
import net.argius.frui.operation.Condition;
import net.argius.frui.operation.Utilities;
import net.argius.frui.text.Pattern;
import net.argius.frui.text.PatternFactory;

public class Grep
extends Condition {
    protected final Pattern pattern;
    protected final boolean detectBinary;
    protected final boolean detectEncoding;

    public Grep(String string) {
        this(string, false);
    }

    public Grep(String string, boolean bl) {
        super(string, bl);
        this.pattern = PatternFactory.create(string, bl);
        this.detectBinary = Environment.getBooleanProperty("detect.binary");
        this.detectEncoding = Environment.getBooleanProperty("detect.encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean operate(FileInfo fileInfo) throws IOException {
        List list = fileInfo.getLineInfoList();
        if (list.isEmpty()) {
            LineNumberReader lineNumberReader;
            File file = fileInfo.getFile();
            if (file.isDirectory()) {
                return false;
            }
            if (this.detectEncoding && !fileInfo.getEncodingType().isDetected()) {
                fileInfo.setEncodingType(Utilities.detectEncoding(file));
            }
            if (this.detectBinary && !fileInfo.getEncodingType().isDetected() && IOUtilities.isBinary(file)) {
                return false;
            }
            if (fileInfo.getEncodingType().isDetected()) {
                String string = fileInfo.getEncodingType().getName();
                lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            } else {
                lineNumberReader = new LineNumberReader(new FileReader(file));
            }
            try {
                this.scanLines(fileInfo, lineNumberReader);
            }
            finally {
                lineNumberReader.close();
            }
            return this.isNegative != !list.isEmpty();
        }
        this.scanLines(list);
        return !list.isEmpty();
    }

    protected boolean matchPattern(String string) {
        return this.pattern.find(string);
    }

    private void scanLines(FileInfo fileInfo, LineNumberReader lineNumberReader) throws IOException {
        String string;
        List list = fileInfo.getLineInfoList();
        while ((string = lineNumberReader.readLine()) != null) {
            if (!this.matchPattern(string)) continue;
            list.add(new LineInfo(lineNumberReader.getLineNumber(), string));
        }
    }

    private void scanLines(List list) {
        LineInfo[] lineInfoArray = list.toArray(new LineInfo[list.size()]);
        int n = lineInfoArray.length;
        for (int i = 0; i < n; ++i) {
            LineInfo lineInfo = lineInfoArray[i];
            if (this.isNegative != this.matchPattern(lineInfo.getLineString())) continue;
            list.remove(lineInfo);
        }
    }
}

