/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.IOException;
import net.argius.frui.FileInfo;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.operation.Condition;

public abstract class Examine
extends Condition {
    public static Examine getInstance(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("D") || string2.equals("DIRECTORY")) {
            return new DIRECTORY();
        }
        if (string2.equals("F") || string2.equals("FILE")) {
            return new FILE();
        }
        if (string2.equals("H") || string2.equals("HIDDEN")) {
            return new HIDDEN();
        }
        if (string2.equals("R") || string2.equals("READ")) {
            return new READ();
        }
        if (string2.equals("W") || string2.equals("WRITE")) {
            return new WRITE();
        }
        throw new IllegalOperationException(1, string);
    }

    public boolean operate(FileInfo fileInfo) throws IOException {
        return this.isNegative != this.examine(fileInfo.getFile());
    }

    protected abstract boolean examine(File var1);

    public static final class WRITE
    extends Examine {
        protected boolean examine(File file) {
            return file.canWrite();
        }
    }

    public static final class READ
    extends Examine {
        protected boolean examine(File file) {
            return file.canRead();
        }
    }

    public static final class HIDDEN
    extends Examine {
        protected boolean examine(File file) {
            return file.isHidden();
        }
    }

    public static final class FILE
    extends Examine {
        protected boolean examine(File file) {
            return file.isFile();
        }
    }

    public static final class DIRECTORY
    extends Examine {
        protected boolean examine(File file) {
            return file.isDirectory();
        }
    }
}

