/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import net.argius.frui.FileInfo;
import net.argius.frui.IllegalOperationException;
import net.argius.frui.Operation;
import net.argius.frui.operation.Utilities;

public final class Evaluate
implements Operation {
    private Operation operation;

    public Evaluate(String string, String[] stringArray) {
        try {
            Class clazz;
            try {
                clazz = this.lookup(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.lookup(string);
            }
            if (clazz == Evaluate.class) {
                throw new IllegalOperationException(1, "circular reference");
            }
            int n = stringArray.length;
            if (n > 0) {
                Object[] objectArray = new Class[n];
                Arrays.fill(objectArray, String.class);
                Constructor constructor = clazz.getConstructor((Class<?>[])objectArray);
                this.operation = (Operation)constructor.newInstance(stringArray);
            } else {
                this.operation = (Operation)clazz.newInstance();
            }
        }
        catch (ClassCastException classCastException) {
            this.throwRuntimeError(string, classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.throwRuntimeError(string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            this.throwRuntimeError(string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throwRuntimeError(string, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.throwRuntimeError(string, noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.throwRuntimeError(string, invocationTargetException);
        }
    }

    private void throwRuntimeError(String string, Throwable throwable) {
        String string2 = throwable.toString() + " : " + string;
        throw new IllegalOperationException(3, string2, throwable);
    }

    private Class lookup(String string) throws ClassNotFoundException {
        String string2 = string.indexOf(46) >= 0 ? string : this.getClass().getPackage().getName() + '.' + string;
        return Class.forName(string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Utilities.getSimpleClassName(this.getClass()));
        stringBuffer.append('(');
        stringBuffer.append(this.operation);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean operate(FileInfo fileInfo) throws IOException {
        return this.operation.operate(fileInfo);
    }
}

