/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.io;

class CharSequenceFIFO
implements CharSequence {
    private static final int DEFAULT_CAPACITY = 16;
    private char[] buffer;
    private int limit;

    public CharSequenceFIFO() {
        this(16);
    }

    public CharSequenceFIFO(int n) {
        this.buffer = new char[n];
        this.limit = 0;
    }

    public char charAt(int n) {
        this.checkRange(n);
        return this.buffer[n];
    }

    public int length() {
        return this.limit;
    }

    public CharSequence subSequence(int n, int n2) {
        this.checkRange(n2);
        return new String(this.buffer, n, n2 - n);
    }

    public void add(char c) {
        this.ensure(1);
        this.buffer[this.limit++] = c;
    }

    public void add(char[] cArray) {
        this.add(cArray, 0, cArray.length);
    }

    public void add(char[] cArray, int n, int n2) {
        this.ensure(n2);
        System.arraycopy(cArray, n, this.buffer, this.limit, n2);
        this.limit += n2;
    }

    public void add(String string) {
        int n = string.length();
        this.ensure(n);
        string.getChars(0, n, this.buffer, this.limit);
        this.limit += n;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(char c, int n) {
        int n2;
        if (n >= this.limit) {
            return -1;
        }
        int n3 = n2 = n < 0 ? 0 : n;
        while (n2 < this.limit) {
            if (this.buffer[n2] == c) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return this.toString().indexOf(string, n);
    }

    public CharSequence draw() {
        return this.draw(this.limit);
    }

    public CharSequence draw(int n) {
        int n2 = Math.min(n, this.limit);
        String string = new String(this.buffer, 0, n2);
        int n3 = this.buffer.length;
        char[] cArray = new char[n3];
        System.arraycopy(this.buffer, n, cArray, 0, n3 - n);
        this.buffer = cArray;
        this.limit -= n;
        return string;
    }

    private void ensure(int n) {
        int n2;
        int n3 = this.buffer.length;
        if (n3 > this.limit + n) {
            return;
        }
        for (n2 = n3; n2 < n3 + n; n2 <<= 1) {
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.buffer, 0, cArray, 0, n3);
        this.buffer = cArray;
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.limit) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof CharSequenceFIFO) {
            CharSequenceFIFO charSequenceFIFO = (CharSequenceFIFO)object;
            if (charSequenceFIFO.limit == this.limit) {
                String string;
                String string2;
                if (charSequenceFIFO.buffer.length > this.buffer.length) {
                    string2 = new String(charSequenceFIFO.buffer, 0, this.limit);
                    string = new String(this.buffer);
                } else if (charSequenceFIFO.buffer.length < this.buffer.length) {
                    string2 = new String(charSequenceFIFO.buffer);
                    string = new String(this.buffer, 0, this.limit);
                } else {
                    string2 = new String(charSequenceFIFO.buffer);
                    string = new String(this.buffer);
                }
                if (string2.equals(string)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + String.valueOf(this.buffer).hashCode();
        n = 37 * n + this.limit;
        return n;
    }

    public String toString() {
        return new String(this.buffer, 0, this.limit);
    }
}

