/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.argius.frui.FileInfo;
import net.argius.frui.Operation;
import net.argius.frui.operation.Print;
import net.argius.frui.operation.PrintInfo;

public final class Application {
    private Operation[] operations;
    private Print print;
    private File[] directories = new File[0];
    private boolean verbose;
    private boolean piped;
    private int limit;
    private int minDepth = 0;
    private int maxDepth = Integer.MAX_VALUE;
    private int scannedCount = 0;
    private int foundCount = 0;
    private int missingFileCount;

    public Application() {
        this.limit = Integer.MAX_VALUE;
    }

    public File[] getDirectories() {
        return (File[])this.directories.clone();
    }

    public void setDirectory(File file) {
        if (file == null) {
            throw new IllegalArgumentException("directory is null");
        }
        this.directories = new File[]{file};
    }

    public void setDirectories(File[] fileArray) {
        if (fileArray == null) {
            throw new IllegalArgumentException("directories is null");
        }
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (fileArray[i] != null) continue;
            throw new IllegalArgumentException("directory[" + i + "] is null");
        }
        this.directories = (File[])fileArray.clone();
    }

    public void addDirectory(File file) {
        if (this.directories == null) {
            throw new IllegalArgumentException("directories is null");
        }
        List<File> list = Arrays.asList(this.directories);
        if (!list.contains(file)) {
            ArrayList<File> arrayList = new ArrayList<File>(list);
            arrayList.add(file);
            this.directories = arrayList.toArray(new File[arrayList.size()]);
        }
    }

    public boolean isPiped() {
        return this.piped;
    }

    public void setPiped(boolean bl) {
        this.piped = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(int n) {
        this.minDepth = n;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    int getScannedCount() {
        return this.scannedCount;
    }

    int getFoundCount() {
        return this.foundCount;
    }

    int getMissingFileCount() {
        return this.missingFileCount;
    }

    public void invoke(List list) {
        this.invoke(list.toArray(new Operation[list.size()]));
    }

    public void invoke(Operation[] operationArray) {
        Print print = new PrintInfo();
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        for (int i = 0; i < operationArray.length; ++i) {
            Operation operation = operationArray[i];
            if (operation instanceof Print) {
                print = (Print)operation;
                continue;
            }
            arrayList.add(operation);
        }
        this.invoke(arrayList.toArray(new Operation[arrayList.size()]), print);
    }

    public void invoke(Operation[] operationArray, Print print) {
        this.operations = operationArray;
        this.print = print;
        this.foundCount = 0;
        this.scannedCount = 0;
        this.missingFileCount = 0;
        try {
            if (this.piped) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                while (this.foundCount < this.limit && (string = bufferedReader.readLine()) != null) {
                    File file = new File(string);
                    if (file.exists()) {
                        this.operate(file);
                        continue;
                    }
                    ++this.missingFileCount;
                }
            } else if (this.directories.length > 0) {
                for (int i = 0; i < this.directories.length; ++i) {
                    this.search(this.directories[i], 0);
                }
            } else {
                this.search(new File("."), 0);
            }
        }
        catch (IOException iOException) {
            print.printError("", iOException);
        }
    }

    private void search(File file, int n) {
        if (this.foundCount >= this.limit) {
            return;
        }
        if (this.minDepth <= n && n <= this.maxDepth) {
            this.operate(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                this.print.printMessage("Can't access : " + file);
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (n > this.maxDepth) continue;
                this.search(file2, n + 1);
            }
        }
    }

    private void operate(File file) {
        block3: {
            ++this.scannedCount;
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFile(file);
            try {
                int n = this.operations.length;
                for (int i = 0; i < n; ++i) {
                    if (this.operations[i].operate(fileInfo)) continue;
                    return;
                }
                ++this.foundCount;
                this.print.operate(fileInfo);
            }
            catch (IOException iOException) {
                this.print.printError(file + " : " + iOException.getMessage(), iOException);
                if (file.exists()) break block3;
                ++this.missingFileCount;
            }
        }
    }
}

