package net.argius.frui.io;

import java.io.*;

/**
 * o̓[eBeBB
 */
public final class IOUtilities {

    private static final int REASON_UNKNOWN = 0xE0000;
    private static final int REASON_ALREADY_EXISTS = 0xE0001;

    /**
     * IOUtilities̐B
     */
    private IOUtilities() {
        // empty
    }

    /**
     * t@CړB
     * @param source ړt@C
     * @param destination ړt@C
     * @param overwrite ㏑ꍇ <code>true</code> A
     *                  ㏑Ȃꍇ <code>false</code>
     * @return t@C̈ړɐꍇ <code>true</code> A
     *                         sꍇ <code>false</code>
     * @throws IOException o̓G[ꍇ
     */
    public static boolean move(File source, File destination, boolean overwrite) throws IOException {
        if (destination.exists()) {
            if (overwrite) {
                destination.delete();
            } else {
                throwIOException("move", destination, REASON_ALREADY_EXISTS);
            }
        }
        mkdirsIfNotExists(destination);
        return source.renameTo(destination);
    }

    /**
     * t@CRs[B
     * @param source Rs[t@C
     * @param destination Rs[t@C
     * @param overwrite ㏑ꍇ <code>true</code> A
     *                  ㏑Ȃꍇ <code>false</code>
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(File source, File destination, boolean overwrite) throws IOException {
        if (destination.exists()) {
            if (!overwrite) {
                throwIOException("copy", destination, REASON_ALREADY_EXISTS);
            }
        }
        copy(source, destination);
    }

    /**
     * t@CRs[B
     * @param source Rs[t@C
     * @param destination Rs[t@C
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(File source, File destination) throws IOException {
        long modifiedTime = source.lastModified();
        mkdirsIfNotExists(destination);
        FileOutputStream fos = new FileOutputStream(destination);
        try {
            FileInputStream fis = new FileInputStream(source);
            try {
                copy(fis, fos);
            } finally {
                fis.close();
            }
        } finally {
            fos.close();
        }
        destination.setLastModified(modifiedTime);
    }

    /**
     * Xg[f[^Rs[B
     * @param is Rs[̓Xg[
     * @param os Rs[o̓Xg[
     * @throws IOException o̓G[ꍇ
     */
    public static void copy(InputStream is, OutputStream os) throws IOException {
        final int bufferSize = 0x10000;
        byte[] buffer = new byte[bufferSize];
        for (int length; (length = is.read(buffer)) >= 0;) {
            os.write(buffer, 0, length);
        }
        os.flush();
    }

    /**
     * t@Cf[^oCiǂ𒲍B
     * @param file t@C
     * @return t@Cf[^oCiȂ<code>true</code>A
     *                         oCiłȂ<code>false</code>
     * @throws IOException o̓G[ꍇ
     */
    public static boolean isBinary(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        try {
            return isBinary(is);
        } finally {
            is.close();
        }
    }

    /**
     * Xg[f[^oCiǂ𒲍B
     * @param is ̓Xg[
     * @return t@Cf[^oCiȂ<code>true</code>A
     *                       łȂ<code>false</code>
     * @throws IOException o̓G[ꍇ
     */
    public static boolean isBinary(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int total = 0;
        byte[] buffer = new byte[1024];
        for (int length; (length = is.read(buffer)) >= 0;) {
            bos.write(buffer, 0, length);
            total += length;
            if (total > 0x10010) {
                break;
            }
        }
        char[] chars = new String(bos.toByteArray()).toCharArray();
        final int limit = Math.min(chars.length, 0x10000);
        for (int i = 0; i < limit; i++) {
            char c = chars[i];
            if ((c < 0x0020 && c != 0x0009 && c != 0x000A && c != 0x000D)
                || c == '\uFFFD') {
                return true;
            }
        }
        return false;
    }

    /**
     * t@C̃fBNg݂Ȃꍇɍ쐬B
     * @param file t@C
     * @throws IOException o̓G[ꍇ 
     */
    private static void mkdirsIfNotExists(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            if (!parent.mkdirs()) {
                throwIOException("mkdir", file, REASON_UNKNOWN);
            }
        }
    }

    /**
     * IOOX[B
     * @param name 
     * @param file t@C
     * @param reasonCode G[R
     * @throws IOException ꂽIOO
     */
    private static void throwIOException(String name, File file, int reasonCode) throws IOException {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("error to ");
        buffer.append(name);
        buffer.append('(');
        buffer.append(file);
        buffer.append(") : ");
        switch (reasonCode) {
            case REASON_ALREADY_EXISTS:
                buffer.append("file already exists");
                break;
            default:
                buffer.append("unknown error");
        }
        throw new IOException(buffer.toString());
    }

}