package net.argius.frui;

import java.io.*;
import java.util.*;

import net.argius.frui.operation.*;

/**
 * AvP[V{́B
 * ̃NX̓XbhZ[tł͂ȂB
 * }`XbhŎgpꍇ̓Xbh[JɂKvB
 */
public final class Application {

    private Operation[] operations;
    private Print print;
    private File[] directories;
    private boolean verbose;
    private boolean piped;
    private int limit;
    private int minDepth;
    private int maxDepth;
    private int scannedCount;
    private int foundCount;
    private int missingFileCount;

    /**
     * Application̐B
     */
    public Application() {
        directories = new File[0];
        minDepth = 0;
        maxDepth = Integer.MAX_VALUE;
        scannedCount = 0;
        foundCount = 0;
        limit = Integer.MAX_VALUE;
    }

    /**
     * ΏۃfBNg̎擾B
     * @return directories fBNg
     */
    public File[] getDirectories() {
        return (File[])directories.clone();
    }

    /**
     * ΏۃfBNgݒ肷B
     * @param directory fBNg
     */
    public void setDirectory(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory is null");
        }
        this.directories = new File[]{directory};
    }

    /**
     * ΏۃfBNg𕡐ݒ肷B
     * @param directories fBNg
     */
    public void setDirectories(File[] directories) {
        if (directories == null) {
            throw new IllegalArgumentException("directories is null");
        }
        for (int i = 0, n = directories.length; i < n; i++) {
            if (directories[i] == null) {
                throw new IllegalArgumentException("directory["
                                                   + i
                                                   + "] is null");
            }
        }
        this.directories = (File[])directories.clone();
    }

    /**
     * ΏۃfBNgǉB 
     * @param directory fBNg
     */
    public void addDirectory(File directory) {
        if (directories == null) {
            throw new IllegalArgumentException("directories is null");
        }
        List directoryList = Arrays.asList(directories);
        if (!directoryList.contains(directory)) {
            List newlist = new ArrayList(directoryList);
            newlist.add(directory);
            this.directories = (File[])newlist.toArray(new File[newlist.size()]);
        }
    }

    /**
     * W͂gp邩ǂ𒲍B
     * @return W͂gpȂ<code>true</code>AłȂ<code>false</code>
     */
    public boolean isPiped() {
        return piped;
    }

    /**
     * W͂gp邩ǂݒ肷B
     * @param piped W͂gpȂ<code>true</code>AłȂ<code>false</code>
     */
    public void setPiped(boolean piped) {
        this.piped = piped;
    }

    /**
     * 璷[hݒ肳Ă邩ǂ𒲍B
     * @return verbose 璷[h
     */
    public boolean isVerbose() {
        return verbose;
    }

    /**
     * 璷[hݒ肷B
     * @param verbose 璷[hgpꍇ <code>true</code>
     *                            gpȂꍇ <code>false</code>
     */
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    /**
     * ̎擾B
     * @return 
     */
    public int getLimit() {
        return limit;
    }

    /**
     * ̐ݒB
     * @param limit 
     */
    public void setLimit(int limit) {
        this.limit = limit;
    }

    /**
    * ŏ[x̎擾B
    * @return ŏ[x
    */
    public int getMinDepth() {
        return minDepth;
    }

    /**
     * ŏ[x̐ݒB
     * @param minDepth ŏ[x
     */
    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    /**
     * ő[x̎擾B
     * @return ő[x
     */
    public int getMaxDepth() {
        return maxDepth;
    }

    /**
     * ő[x̐ݒB
     * @param maxDepth ő[x
     */
    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    /**
     * t@C̎擾B
     * @return t@C
     */
    int getScannedCount() {
        return scannedCount;
    }

    /**
     * Ɉvt@C̎擾B
     * @return Ɉvt@C
     */
    int getFoundCount() {
        return foundCount;
    }

    /**
     * Ȃt@C̎擾B
     * @return Ȃt@C
     */
    int getMissingFileCount() {
        return missingFileCount;
    }

    /**
     * AvP[VNB
     * @param operationList OperatioñXg
     */
    public void invoke(List operationList) {
        invoke((Operation[])operationList.toArray(new Operation[operationList.size()]));
    }

    /**
     * AvP[VNB
     * @param operations Operation̔z
     */
    public void invoke(Operation[] operations) {
        Print p = new PrintInfo();
        List list = new ArrayList();
        for (int i = 0; i < operations.length; i++) {
            Operation operation = operations[i];
            if (operation instanceof Print) {
                p = (Print)operation;
            } else {
                list.add(operation);
            }
        }
        invoke((Operation[])list.toArray(new Operation[list.size()]), p);
    }

    /**
     * AvP[VNB
     * @param operations Operation̔z
     * @param print Print
     */
    public void invoke(Operation[] operations, Print print) {
        this.operations = operations;
        this.print = print;
        foundCount = 0;
        scannedCount = 0;
        missingFileCount = 0;
        try {
            if (piped) {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                String line;
                while (foundCount < limit && (line = stdin.readLine()) != null) {
                    File file = new File(line);
                    if (file.exists()) {
                        operate(file);
                    } else {
                        ++missingFileCount;
                    }
                }
            } else if (directories.length > 0) {
                for (int i = 0; i < directories.length; i++) {
                    search(directories[i], 0);
                }
            } else {
                search(new File("."), 0);
            }
        } catch (IOException ex) {
            print.printError("", ex);
        }
    }

    /**
     * t@CċAIɑB
     * @param file t@C
     * @param depth [
     */
    private void search(File file, int depth) {
        if (foundCount >= limit) {
            return;
        }
        if (minDepth <= depth && depth <= maxDepth) {
            operate(file);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                print.printMessage("Can't access : " + file);
                return;
            }
            for (int i = 0; i < files.length; i++) {
                File subfile = files[i];
                if (depth <= maxDepth) {
                    search(subfile, depth + 1);
                }
            }
        }
    }

    /**
     * t@CB
     * @param file t@C
     */
    private void operate(File file) {
        ++scannedCount;
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFile(file);
        try {
            for (int i = 0, n = operations.length; i < n; i++) {
                if (!operations[i].operate(fileInfo)) {
                    return;
                }
            }
            ++foundCount;
            print.operate(fileInfo);
        } catch (IOException ex) {
            print.printError(file + " : " + ex.getMessage(), ex);
            if (!file.exists()) {
                ++missingFileCount;
            }
        }
    }

}