/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.text;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.argius.frui.IllegalOperationException;

public final class TimePoints {
    private static final String[] TIME_FORMATS = new String[]{"yyyyMMdd", "yyyyMMddHH", "yyyyMMddHHmm", "yyyyMMddHHmmss"};
    private static final int[] TIME_UNITS = new int[]{5, 11, 12, 13, 14};
    private final long startPoint;
    private final long endPoint;

    public TimePoints(long l, long l2) {
        if (l > l2) {
            throw new IllegalOperationException(1, "start(" + l + ") > end(" + l2 + ")");
        }
        this.startPoint = l;
        this.endPoint = l2;
    }

    public TimePoints(String string) {
        long l;
        long l2;
        int n = 0;
        int n2 = string.charAt(n);
        switch (n2) {
            case 43: 
            case 45: 
            case 61: 
            case 91: 
            case 93: {
                ++n;
                break;
            }
            default: {
                n2 = 61;
            }
        }
        int n3 = string.length() - 1;
        char c = string.charAt(n3);
        boolean bl = Character.isDigit(c);
        if (bl) {
            ++n3;
        }
        String string2 = string.substring(n, n3);
        try {
            int n4;
            Calendar calendar = Calendar.getInstance();
            if (bl && string2.length() > 7) {
                n4 = this.parseAbsoluteTime(calendar, string2);
            } else {
                char c2 = bl ? (char)'d' : (char)c;
                n4 = this.parseRelativeTime(calendar, string2, c2);
            }
            l2 = calendar.getTimeInMillis();
            calendar.add(n4, 1);
            l = calendar.getTimeInMillis();
        }
        catch (ParseException parseException) {
            throw new IllegalOperationException(1, "", parseException);
        }
        switch (n2) {
            case 43: {
                this.startPoint = 0L;
                this.endPoint = l2 - 1L;
                break;
            }
            case 93: {
                this.startPoint = 0L;
                this.endPoint = l - 1L;
                break;
            }
            case 61: {
                this.startPoint = l2;
                this.endPoint = l - 1L;
                break;
            }
            case 45: {
                this.startPoint = l;
                this.endPoint = Long.MAX_VALUE;
                break;
            }
            case 91: {
                this.startPoint = l2;
                this.endPoint = Long.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
    }

    private int parseAbsoluteTime(Calendar calendar, String string) throws ParseException {
        for (int i = 0; i < TIME_FORMATS.length; ++i) {
            String string2 = TIME_FORMATS[i];
            if (string.length() != string2.length()) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            calendar.setTime(simpleDateFormat.parse(string));
            return TIME_UNITS[i];
        }
        throw new ParseException("illegal expression : " + string, -1);
    }

    private int parseRelativeTime(Calendar calendar, String string, char c) throws ParseException {
        int n;
        int n2;
        int n3 = Integer.parseInt(string);
        switch (Character.toLowerCase(c)) {
            case 'd': {
                n2 = 0;
                break;
            }
            case 'h': {
                n2 = 1;
                break;
            }
            case 'm': {
                n2 = 2;
                break;
            }
            case 's': {
                n2 = 3;
                break;
            }
            default: {
                throw new ParseException("unit : " + c, -1);
            }
        }
        for (n = n2 + 1; n < TIME_UNITS.length; ++n) {
            calendar.set(TIME_UNITS[n], 0);
        }
        n = TIME_UNITS[n2];
        calendar.add(n, -n3);
        return n;
    }

    public long getStartPoint() {
        return this.startPoint;
    }

    public long getEndPoint() {
        return this.endPoint;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd_HH:mm:ss:SSS");
        if (this.startPoint > 0L) {
            stringBuffer.append(simpleDateFormat.format(new Date(this.startPoint)));
        }
        stringBuffer.append('-');
        if (this.endPoint < Long.MAX_VALUE) {
            stringBuffer.append(simpleDateFormat.format(new Date(this.endPoint)));
        }
        return stringBuffer.toString();
    }
}

