/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui.operation;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.argius.frui.FileInfo;
import net.argius.frui.operation.Print;
import net.argius.frui.operation.Utilities;

public final class PrintList
extends Print {
    private static final String SPACE19 = "                   ";
    private final String propFileSizeFormatString = Utilities.getFileSizeFormatString();
    private final String propDateFormatString = Utilities.getDateFormatString();
    private final boolean useFileSizeFormat = this.propFileSizeFormatString.length() > 0;
    private final int formatStringLength = this.propFileSizeFormatString.length();

    protected void printInfo(FileInfo fileInfo) throws IOException {
        String string;
        Object object;
        File file = fileInfo.getFile();
        boolean bl = file.isDirectory();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl ? (char)'D' : ' ');
        long l = file.length();
        if (this.useFileSizeFormat) {
            if (bl) {
                object = SPACE19;
            } else {
                DecimalFormat decimalFormat = new DecimalFormat(this.propFileSizeFormatString);
                object = SPACE19 + decimalFormat.format(l);
            }
            int n = ((String)object).length() - this.formatStringLength;
            string = ((String)object).substring(n);
        } else {
            string = bl ? SPACE19 : this.padLong(l);
        }
        stringBuffer.append(string);
        stringBuffer.append(' ');
        object = new SimpleDateFormat(this.propDateFormatString);
        stringBuffer.append(((DateFormat)object).format(new Date(file.lastModified())));
        stringBuffer.append(' ');
        this.print(stringBuffer);
        this.println(file);
    }
}

