/*
 * Decompiled with CFR 0.152.
 */
package net.argius.frui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.argius.frui.Application;
import net.argius.frui.Operation;
import net.argius.frui.operation.Print;
import net.argius.frui.operation.PrintInfo;

public final class VerboseMode {
    private VerboseMode() {
    }

    public static void invoke(Application application, List list) {
        Operation[] operationArray = list.toArray(new Operation[list.size()]);
        VerboseMode.invoke(application, operationArray);
    }

    public static void invoke(Application application, Operation[] operationArray) {
        Print print = new PrintInfo();
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        for (int i = 0; i < operationArray.length; ++i) {
            Operation operation = operationArray[i];
            if (operation instanceof Print) {
                print = (Print)operation;
                continue;
            }
            arrayList.add(operation);
        }
        Operation[] operationArray2 = arrayList.toArray(new Operation[arrayList.size()]);
        VerboseMode.printOptions(application, operationArray2, print);
        long l = System.currentTimeMillis();
        application.invoke(operationArray2, print);
        long l2 = System.currentTimeMillis() - l;
        String string = "[TIME]   " + (float)l2 / 1000.0f + " seconds";
        print.printMessage(string);
        String string2 = "[RESULT] found " + application.getFoundCount() + " files / " + application.getScannedCount();
        int n = application.getMissingFileCount();
        if (n > 0) {
            string2 = string2 + " (" + n + " missing files)";
        }
        print.printMessage(string2);
    }

    private static void printOptions(Application application, Operation[] operationArray, Print print) {
        Object object;
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("directory", Arrays.asList(application.getDirectories()));
        hashMap.put("verbose", application.isVerbose());
        int n2 = application.getMinDepth();
        int n3 = application.getMaxDepth();
        if (n2 != 0 || n3 != Integer.MAX_VALUE) {
            String string = "";
            if (n2 != 0) {
                string = string + n2;
            }
            string = string + "..";
            if (n3 != Integer.MAX_VALUE) {
                string = string + n3;
            }
            hashMap.put("depthRange", string);
        }
        if ((n = application.getLimit()) != Integer.MAX_VALUE) {
            hashMap.put("limit", new Integer(n));
        }
        printWriter.print("[MODE]  ");
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            printWriter.print(' ');
            printWriter.print(object.getKey());
            printWriter.print('=');
            printWriter.print(object.getValue());
        }
        printWriter.println();
        printWriter.print("[PROP]  ");
        object = System.getProperties().entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String string = (String)entry.getKey();
            if (!string.startsWith("net.argius.frui.")) continue;
            printWriter.print(' ');
            printWriter.print(string.substring("net.argius.frui.".length()));
            printWriter.print('=');
            printWriter.print(entry.getValue());
        }
        printWriter.println();
        printWriter.print("[FILTER] ");
        boolean bl = true;
        int n4 = operationArray.length;
        for (int i = 0; i < n4; ++i) {
            Operation operation = operationArray[i];
            if (bl) {
                bl = false;
            } else {
                printWriter.print(" & ");
            }
            printWriter.print(operation);
        }
        printWriter.print(" & ");
        printWriter.print(print);
        printWriter.flush();
        print.printMessage(((Object)stringWriter).toString());
    }
}

